/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class ProcessUtility {
    private ProcessUtility() {
    }

    public static long computeBlockContextWidth(RenderNode box) {
        RenderBox parentBlockContext = box.getParent();
        if (parentBlockContext == null) {
            int type = box.getNodeType();
            if ((type & 0x812) == 2066) {
                PageAreaBox pageAreaBox = (PageAreaBox)box;
                LogicalPageBox pageBox = pageAreaBox.getLogicalPage();
                if (pageBox == null) {
                    return 0L;
                }
                return pageBox.getPageWidth();
            }
            if ((type & 0x412) == 1042) {
                LogicalPageBox logicalPage = (LogicalPageBox)box;
                return logicalPage.getPageWidth();
            }
            return 0L;
        }
        return parentBlockContext.getStaticBoxLayoutProperties().getBlockContextWidth();
    }

    public static boolean isContent(RenderBox element, boolean ellipseAsBackground, boolean shapesAsContent) {
        if (element.getNodeType() == 258) {
            RenderableReplacedContentBox contentBox = (RenderableReplacedContentBox)element;
            RenderableReplacedContent rpc = contentBox.getContent();
            Object rawContentObject = rpc.getRawObject();
            if (!(rawContentObject instanceof DrawableWrapper)) {
                return true;
            }
            DrawableWrapper wrapper = (DrawableWrapper)rawContentObject;
            Object rawbackend = wrapper.getBackend();
            if (!(rawbackend instanceof ShapeDrawable)) {
                return true;
            }
            ShapeDrawable drawable = (ShapeDrawable)rawbackend;
            Shape rawObject = drawable.getShape();
            StyleSheet styleSheet = element.getStyleSheet();
            if (!shapesAsContent) {
                return false;
            }
            if (rawObject instanceof Line2D) {
                if (ProcessUtility.hasBorderEdge(styleSheet)) {
                    Line2D line = (Line2D)rawObject;
                    if (line.getY1() == line.getY2()) {
                        return false;
                    }
                    if (line.getX1() == line.getX2()) {
                        return false;
                    }
                }
            } else {
                if (rawObject instanceof Rectangle2D) {
                    return false;
                }
                if (ellipseAsBackground && rawObject instanceof Ellipse2D) {
                    return false;
                }
                if (rawObject instanceof RoundRectangle2D) {
                    return false;
                }
            }
            return true;
        }
        for (RenderNode child = element.getFirstChild(); child != null; child = child.getNext()) {
            int type = child.getNodeType();
            if ((type & 0x42) == 66) {
                return true;
            }
            if (type != 17) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBorderEdge(StyleSheet style) {
        Stroke s = (Stroke)style.getStyleProperty(ElementStyleKeys.STROKE);
        if (!(s instanceof BasicStroke)) {
            return false;
        }
        BorderStyle borderStyle = StrokeUtility.translateStrokeStyle(s);
        return !BorderStyle.NONE.equals(borderStyle);
    }

    public static BorderEdge produceBorderEdge(StyleSheet style) {
        Stroke s = (Stroke)style.getStyleProperty(ElementStyleKeys.STROKE);
        if (!(s instanceof BasicStroke)) {
            return null;
        }
        BasicStroke bs = (BasicStroke)s;
        BorderStyle borderStyle = StrokeUtility.translateStrokeStyle(s);
        if (BorderStyle.NONE.equals(borderStyle)) {
            return null;
        }
        Color c = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
        return new BorderEdge(borderStyle, c, StrictGeomUtility.toInternalValue(bs.getLineWidth()));
    }

    public static long computeLength(long min, long max, long pref) {
        if (pref > max) {
            if (max < min) {
                return min;
            }
            return max;
        }
        if (pref < min) {
            if (max < min) {
                return max;
            }
            return min;
        }
        if (max < pref) {
            return max;
        }
        return pref;
    }
}

