/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;

public class ReplacedContentUtil {
    private ReplacedContentUtil() {
    }

    public static long computeWidth(RenderableReplacedContentBox content) {
        long bcw = ProcessUtility.computeBlockContextWidth(content);
        long width = ReplacedContentUtil.computeWidthInternal(content, bcw);
        RenderableReplacedContent replacedContent = content.getContent();
        return ProcessUtility.computeLength(replacedContent.getMinimumWidth().resolve(bcw), replacedContent.getMaximumWidth().resolve(bcw), width);
    }

    public static long computeHeight(RenderableReplacedContentBox content, long bcw, long computedWidth) {
        RenderableReplacedContent replacedContent = content.getContent();
        long height = ReplacedContentUtil.computeHeightInternal(replacedContent, bcw, computedWidth);
        return ProcessUtility.computeLength(replacedContent.getMinimumHeight().resolve(bcw), replacedContent.getMaximumHeight().resolve(bcw), height);
    }

    public static long computeWidthInternal(RenderableReplacedContentBox contentBox, long blockContextWidth) {
        RenderableReplacedContent content = contentBox.getContent();
        RenderLength requestedWidth = content.getRequestedWidth();
        RenderLength requestedHeight = content.getRequestedHeight();
        if (RenderLength.AUTO.equals(requestedWidth)) {
            if (RenderLength.AUTO.equals(requestedHeight)) {
                return content.getContentWidth();
            }
            long contentHeight = content.getContentHeight();
            if (contentHeight > 0L) {
                long height = requestedHeight.resolve(blockContextWidth);
                return height * contentBox.getComputedWidth() / contentHeight;
            }
            return 0L;
        }
        return requestedWidth.resolve(blockContextWidth);
    }

    private static long computeHeightInternal(RenderableReplacedContent content, long blockContextWidth, long computedWidth) {
        RenderLength requestedHeight = content.getRequestedHeight();
        if (RenderLength.AUTO.equals(content.getRequestedWidth())) {
            if (RenderLength.AUTO.equals(requestedHeight)) {
                long contentWidth = content.getContentWidth();
                if (contentWidth > 0L && computedWidth != 0L) {
                    return computedWidth * content.getContentHeight() / contentWidth;
                }
                return content.getContentHeight();
            }
            return requestedHeight.resolve(blockContextWidth);
        }
        if (RenderLength.AUTO.equals(requestedHeight)) {
            long contentWidth = content.getContentWidth();
            if (contentWidth > 0L) {
                return computedWidth * content.getContentHeight() / contentWidth;
            }
            return 0L;
        }
        return requestedHeight.resolve(blockContextWidth);
    }
}

