/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.CenterAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.JustifyAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LastLineTextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.RightAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.DefaultSequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineBoxSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineNodeSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.ReplacedContentSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SpacerSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.BoxAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.InlineBlockAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.NodeAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.ReplacedContentAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.TextElementAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.VerticalAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

public final class RevalidateAllAxisLayoutStep
extends IterateVisualProcessStep {
    private static final Log logger = LogFactory.getLog(RevalidateAllAxisLayoutStep.class);
    private static final long OVERFLOW_DUMMY_WIDTH = StrictGeomUtility.toInternalValue(20000.0);
    private LastLineTextAlignmentProcessor centerProcessor;
    private LastLineTextAlignmentProcessor leftProcessor;
    private LastLineTextAlignmentProcessor rightProcessor;
    private LastLineTextAlignmentProcessor justifiedProcessor;
    private PageGrid pageGrid;
    private OutputProcessorMetaData metaData;
    private VerticalAlignmentProcessor verticalAlignmentProcessor;

    public RevalidateAllAxisLayoutStep(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.verticalAlignmentProcessor = new VerticalAlignmentProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(LogicalPageBox pageBox) {
        this.pageGrid = pageBox.getPageGrid();
        try {
            this.startProcessing(pageBox);
        }
        finally {
            this.pageGrid = null;
        }
    }

    protected boolean startBlockLevelBox(RenderBox box) {
        return !box.isCacheValid();
    }

    protected boolean startRowLevelBox(RenderBox box) {
        return !box.isCacheValid();
    }

    protected boolean startCanvasLevelBox(RenderBox box) {
        return !box.isCacheValid();
    }

    private void performVerticalBlockAlignment(ParagraphRenderBox box) {
        RenderNode lastChildNode = box.getLastChild();
        if (lastChildNode == null) {
            return;
        }
        BoxDefinition boxDefinition = box.getBoxDefinition();
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        long insetBottom = blp.getBorderBottom() + boxDefinition.getPaddingBottom();
        long insetTop = blp.getBorderTop() + boxDefinition.getPaddingTop();
        long childY2 = lastChildNode.getCachedY() + lastChildNode.getCachedHeight() + lastChildNode.getEffectiveMarginBottom();
        long childY1 = box.getFirstChild().getCachedY();
        long usedHeight = childY2 - childY1;
        long computedHeight = box.getCachedHeight();
        if (computedHeight > usedHeight) {
            ElementAlignment valign = box.getNodeLayoutProperties().getVerticalAlignment();
            if (ElementAlignment.BOTTOM.equals(valign)) {
                long boxBottom = box.getCachedY() + box.getCachedHeight() - insetBottom;
                long delta = boxBottom - childY2;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            } else if (ElementAlignment.MIDDLE.equals(valign)) {
                long extraHeight = computedHeight - usedHeight;
                long boxTop = box.getCachedY() + insetTop + extraHeight / 2L;
                long delta = boxTop - childY1;
                CacheBoxShifter.shiftBoxChilds(box, delta);
            }
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraph) {
        ElementAlignment elementAlignment;
        if (paragraph.getStaticBoxLayoutProperties().isOverflowY()) {
            this.performVerticalBlockAlignment(paragraph);
            return;
        }
        boolean overflowX = paragraph.getStaticBoxLayoutProperties().isOverflowX();
        long paragraphBottom = paragraph.getCachedY() + paragraph.getCachedHeight();
        RenderNode lastLine = paragraph.getLastChild();
        if (lastLine == null) {
            return;
        }
        ElementAlignment lastLineAlignment = paragraph.getLastLineAlignment();
        if (lastLineAlignment == (elementAlignment = paragraph.getTextAlignment()) && lastLine.getCachedY() + lastLine.getCachedHeight() <= paragraphBottom) {
            return;
        }
        ParagraphPoolBox prev = null;
        for (RenderNode node = paragraph.getFirstChild(); node != null; node = node.getNext()) {
            long lineStart;
            ParagraphPoolBox mergedLine;
            if (node.getNodeType() != 322) {
                throw new IllegalStateException("Encountered " + node.getClass());
            }
            ParagraphPoolBox inlineRenderBox = (ParagraphPoolBox)node;
            long y = inlineRenderBox.getCachedY();
            long height = inlineRenderBox.getCachedHeight();
            if (inlineRenderBox != lastLine && y + height <= paragraphBottom) {
                prev = inlineRenderBox;
                continue;
            }
            if (inlineRenderBox == lastLine && y + height <= paragraphBottom) {
                mergedLine = inlineRenderBox;
            } else {
                mergedLine = this.rebuildLastLine(prev, inlineRenderBox);
                while (node != null) {
                    RenderNode oldNode = node;
                    node = node.getNext();
                    paragraph.remove(oldNode);
                }
            }
            if (mergedLine == null) {
                return;
            }
            LastLineTextAlignmentProcessor proc = this.create(lastLineAlignment);
            SequenceList sequenceList = this.createHorizontalSequenceList(mergedLine);
            long lineEnd = overflowX ? OVERFLOW_DUMMY_WIDTH : paragraph.getContentAreaX2();
            if (lineEnd - (lineStart = paragraph.getContentAreaX1()) <= 0L) {
                long minimumChunkWidth = paragraph.getMinimumChunkWidth();
                proc.initialize(this.metaData, sequenceList, lineStart, lineStart + minimumChunkWidth, this.pageGrid, overflowX);
                logger.warn((Object)"Revalidate: Auto-Corrected zero-width linebox.");
            } else {
                proc.initialize(this.metaData, sequenceList, lineStart, lineEnd, this.pageGrid, overflowX);
            }
            proc.performLastLineAlignment();
            proc.deinitialize();
            BoxAlignContext valignContext = this.createVerticalAlignContext(mergedLine);
            StaticBoxLayoutProperties blp = mergedLine.getStaticBoxLayoutProperties();
            BoxDefinition bdef = mergedLine.getBoxDefinition();
            long insetTop = blp.getBorderTop() + bdef.getPaddingTop();
            long contentAreaY1 = mergedLine.getCachedY() + insetTop;
            long lineHeight = mergedLine.getLineHeight();
            this.verticalAlignmentProcessor.align(valignContext, contentAreaY1, lineHeight);
            this.performVerticalBlockAlignment(paragraph);
            return;
        }
    }

    private BoxAlignContext createVerticalAlignContext(InlineRenderBox box) {
        BoxAlignContext alignContext = new BoxAlignContext(box);
        FastStack contextStack = new FastStack(50);
        FastStack alignContextStack = new FastStack(50);
        RenderNode next = box.getFirstChild();
        RenderBox context = box;
        while (next != null) {
            int nodeType = next.getNodeType();
            if ((nodeType & 0x42) == 66) {
                BoxAlignContext childBoxContext;
                RenderBox nBox = (RenderBox)next;
                RenderNode firstChild = nBox.getFirstChild();
                if (firstChild != null) {
                    contextStack.push((Object)context);
                    alignContextStack.push((Object)alignContext);
                    next = firstChild;
                    childBoxContext = new BoxAlignContext(nBox);
                    alignContext.addChild(childBoxContext);
                    context = nBox;
                    alignContext = childBoxContext;
                } else {
                    childBoxContext = new BoxAlignContext(nBox);
                    alignContext.addChild(childBoxContext);
                    next = nBox.getNext();
                }
            } else {
                if (nodeType == 17) {
                    alignContext.addChild(new TextElementAlignContext((RenderableText)next));
                } else if (nodeType == 258) {
                    alignContext.addChild(new ReplacedContentAlignContext((RenderableReplacedContentBox)next, 0L));
                } else if ((nodeType & 0x12) == 18) {
                    alignContext.addChild(new InlineBlockAlignContext((RenderBox)next));
                } else {
                    alignContext.addChild(new NodeAlignContext(next));
                }
                next = next.getNext();
            }
            while (next == null && !contextStack.isEmpty()) {
                next = context.getNext();
                context = (RenderBox)contextStack.pop();
                alignContext.validate();
                alignContext = (BoxAlignContext)alignContextStack.pop();
            }
        }
        return alignContext;
    }

    private SequenceList createHorizontalSequenceList(InlineRenderBox box) {
        DefaultSequenceList sequenceList = new DefaultSequenceList();
        sequenceList.add(StartSequenceElement.INSTANCE, box);
        RenderNode next = box.getFirstChild();
        RenderBox context = box;
        FastStack contextStack = new FastStack(50);
        boolean containsContent = false;
        while (next != null) {
            int nodeType = next.getNodeType();
            if ((nodeType & 0x42) == 66) {
                RenderBox nBox = (RenderBox)next;
                RenderNode firstChild = nBox.getFirstChild();
                if (firstChild != null) {
                    contextStack.push((Object)context);
                    next = firstChild;
                    sequenceList.add(StartSequenceElement.INSTANCE, nBox);
                    context = nBox;
                } else {
                    sequenceList.add(StartSequenceElement.INSTANCE, nBox);
                    sequenceList.add(EndSequenceElement.INSTANCE, nBox);
                    next = nBox.getNext();
                }
            } else {
                if (nodeType == 17) {
                    sequenceList.add(TextSequenceElement.INSTANCE, next);
                    containsContent = true;
                } else if (nodeType == 258) {
                    sequenceList.add(ReplacedContentSequenceElement.INSTANCE, next);
                    containsContent = true;
                } else if (nodeType == 65) {
                    if (containsContent) {
                        sequenceList.add(SpacerSequenceElement.INSTANCE, next);
                    }
                } else if ((nodeType & 0x12) == 18) {
                    containsContent = true;
                    sequenceList.add(InlineBoxSequenceElement.INSTANCE, next);
                } else {
                    containsContent = true;
                    sequenceList.add(InlineNodeSequenceElement.INSTANCE, next);
                }
                next = next.getNext();
            }
            while (next == null && !contextStack.isEmpty()) {
                sequenceList.add(EndSequenceElement.INSTANCE, context);
                next = context.getNext();
                context = (RenderBox)contextStack.pop();
            }
        }
        sequenceList.add(EndSequenceElement.INSTANCE, box);
        return sequenceList;
    }

    private LastLineTextAlignmentProcessor create(ElementAlignment alignment) {
        if (ElementAlignment.CENTER.equals(alignment)) {
            if (this.centerProcessor == null) {
                this.centerProcessor = new CenterAlignmentProcessor();
            }
            return this.centerProcessor;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            if (this.rightProcessor == null) {
                this.rightProcessor = new RightAlignmentProcessor();
            }
            return this.rightProcessor;
        }
        if (ElementAlignment.JUSTIFY.equals(alignment)) {
            if (this.justifiedProcessor == null) {
                this.justifiedProcessor = new JustifyAlignmentProcessor();
            }
            return this.justifiedProcessor;
        }
        if (this.leftProcessor == null) {
            this.leftProcessor = new LeftAlignmentProcessor();
        }
        return this.leftProcessor;
    }

    private ParagraphPoolBox rebuildLastLine(ParagraphPoolBox lineBox, ParagraphPoolBox nextBox) {
        if (lineBox == null) {
            if (nextBox == null) {
                throw new NullPointerException("Both Line- and Next-Line are null.");
            }
            return this.rebuildLastLine(nextBox, (ParagraphPoolBox)nextBox.getNext());
        }
        if (nextBox == null) {
            return lineBox;
        }
        boolean needToAddSpacing = true;
        FastStack contextStack = new FastStack(50);
        RenderNode next = nextBox.getFirstChild();
        MergeContext context = new MergeContext(lineBox, nextBox);
        while (next != null) {
            RenderBox writeContext = context.getWriteContext();
            StaticBoxLayoutProperties staticBoxLayoutProperties = writeContext.getStaticBoxLayoutProperties();
            long spaceWidth = staticBoxLayoutProperties.getSpaceWidth();
            if (spaceWidth == 0L) {
                FontMetrics fontMetrics = this.metaData.getFontMetrics(writeContext.getStyleSheet());
                spaceWidth = StrictGeomUtility.fromFontMetricsValue(fontMetrics.getCharWidth(32));
                staticBoxLayoutProperties.setSpaceWidth(spaceWidth);
            }
            if ((next.getNodeType() & 2) == 2) {
                RenderBox nBox = (RenderBox)next;
                RenderNode firstChild = nBox.getFirstChild();
                if (firstChild != null) {
                    RenderBox newWriter;
                    SpacerRenderNode spacer;
                    contextStack.push((Object)context);
                    next = firstChild;
                    RenderNode writeContextLastChild = writeContext.getLastChild();
                    if ((writeContextLastChild.getNodeType() & 2) == 2) {
                        if (writeContextLastChild.getInstanceId() == nBox.getInstanceId()) {
                            context = new MergeContext((RenderBox)writeContextLastChild, nBox);
                        } else {
                            if (needToAddSpacing) {
                                if (spaceWidth > 0L) {
                                    spacer = new SpacerRenderNode(spaceWidth, 0L, false, 1);
                                    spacer.setVirtualNode(true);
                                    writeContext.addGeneratedChild(spacer);
                                }
                                needToAddSpacing = false;
                            }
                            newWriter = (RenderBox)nBox.derive(false);
                            newWriter.setVirtualNode(true);
                            writeContext.addGeneratedChild(newWriter);
                            context = new MergeContext(newWriter, nBox);
                        }
                    } else {
                        if (needToAddSpacing) {
                            if (spaceWidth > 0L) {
                                spacer = new SpacerRenderNode(spaceWidth, 0L, false, 1);
                                spacer.setVirtualNode(true);
                                writeContext.addGeneratedChild(spacer);
                            }
                            needToAddSpacing = false;
                        }
                        newWriter = (RenderBox)nBox.derive(false);
                        newWriter.setVirtualNode(true);
                        writeContext.addGeneratedChild(newWriter);
                        context = new MergeContext(newWriter, nBox);
                    }
                } else {
                    if (needToAddSpacing) {
                        if (spaceWidth > 0L) {
                            SpacerRenderNode spacer = new SpacerRenderNode(spaceWidth, 0L, false, 1);
                            spacer.setVirtualNode(true);
                            writeContext.addGeneratedChild(spacer);
                        }
                        needToAddSpacing = false;
                    }
                    RenderNode box = nBox.derive(true);
                    box.setVirtualNode(true);
                    writeContext.addGeneratedChild(box);
                    next = nBox.getNext();
                }
            } else {
                if (needToAddSpacing) {
                    RenderNode lastChild = writeContext.getLastChild();
                    if (spaceWidth > 0L && lastChild != null && lastChild.getNodeType() != 65) {
                        SpacerRenderNode spacer = new SpacerRenderNode(spaceWidth, 0L, false, 1);
                        spacer.setVirtualNode(true);
                        writeContext.addGeneratedChild(spacer);
                    }
                    needToAddSpacing = false;
                }
                RenderNode child = next.derive(true);
                child.setVirtualNode(true);
                writeContext.addGeneratedChild(child);
                next = next.getNext();
            }
            while (next == null && !contextStack.isEmpty()) {
                next = context.getReadContext().getNext();
                context = (MergeContext)contextStack.pop();
            }
        }
        return this.rebuildLastLine(lineBox, (ParagraphPoolBox)nextBox.getNext());
    }

    private static class MergeContext {
        private RenderBox readContext;
        private RenderBox writeContext;

        protected MergeContext(RenderBox writeContext, RenderBox readContext) {
            this.readContext = readContext;
            this.writeContext = writeContext;
        }

        public RenderBox getReadContext() {
            return this.readContext;
        }

        public RenderBox getWriteContext() {
            return this.writeContext;
        }
    }
}

