/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;

public final class RollbackStep
extends IterateStructuralProcessStep {
    private static final Log logger = LogFactory.getLog(RollbackStep.class);
    private boolean deepDirty;

    public void compute(LogicalPageBox pageBox) {
        this.deepDirty = false;
        if (!pageBox.isAppliedSeen()) {
            throw new IllegalStateException("How can I not see the root of the layout-tree?");
        }
        if (this.processBoxRollback(pageBox)) {
            this.startProcessing(pageBox);
        }
        pageBox.rollbackSaveInformation();
    }

    private boolean processBoxRollback(RenderBox pageBox) {
        if (pageBox.isAppliedOpen() || pageBox.getAppliedContentRefCount() > 0) {
            pageBox.reopenAfterRollback(this.deepDirty);
            return true;
        }
        return false;
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    private boolean processBox(RenderBox parent) {
        boolean needDeepDive = false;
        if (parent.getNodeType() == 1042) {
            LogicalPageBox lb = (LogicalPageBox)parent;
            if (this.processBoxRollback(lb.getWatermarkArea())) {
                needDeepDive = true;
            }
            if (this.processBoxRollback(lb.getHeaderArea())) {
                needDeepDive = true;
            }
            if (this.processBoxRollback(lb.getFooterArea())) {
                needDeepDive = true;
            }
            if (this.processBoxRollback(lb.getRepeatFooterArea())) {
                needDeepDive = true;
            }
        }
        RenderNode child = parent.getFirstChild();
        while (child != null) {
            int type = child.getNodeType();
            if (type == 129) {
                child = child.getNext();
                continue;
            }
            if ((type & 2) != 2) {
                throw new IllegalStateException("Assertation error: A rollback-process encountered a render-node it should not have encountered.");
            }
            RenderBox box = (RenderBox)child;
            if (!box.isAppliedSeen()) {
                RenderNode next = child.getNext();
                parent.removeGenerated(box);
                parent.resetCacheState(this.deepDirty);
                child = next;
                continue;
            }
            if (box.isAppliedOpen() || box.getAppliedContentRefCount() > 0) {
                box.reopenAfterRollback(this.deepDirty);
                needDeepDive = true;
            }
            child = child.getNext();
        }
        return needDeepDive;
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        this.deepDirty = true;
        return this.processBox(box);
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return this.processBox(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        this.deepDirty = true;
        return this.processBox(box);
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        this.deepDirty = true;
        this.processBox(box);
    }

    protected boolean startRowBox(RenderBox box) {
        this.deepDirty = true;
        return this.processBox(box);
    }

    protected boolean startOtherBox(RenderBox box) {
        this.deepDirty = true;
        return this.processBox(box);
    }
}

