/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;

public class ValidateModelStep
extends IterateStructuralProcessStep {
    private static final Log logger = LogFactory.getLog(ValidateModelStep.class);
    private boolean result;

    public boolean isLayoutable(LogicalPageBox root) {
        this.result = true;
        this.processBoxChilds(root);
        return this.result;
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isCacheValid()) {
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Canvas: Box is open: " + box));
            }
            this.result = false;
            return false;
        }
        return box.getAppliedContentRefCount() != 0;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isCacheValid()) {
            return false;
        }
        if (box.isOpen()) {
            if (box.getNext() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Box is open with next element pending : " + box));
                }
                this.result = false;
                return false;
            }
            if (box.getStaticBoxLayoutProperties().isPlaceholderBox() && box.getFirstChild() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Block: Box is placeholder : " + box));
                }
                this.result = false;
                return false;
            }
        } else if (box.getAppliedContentRefCount() == 0) {
            return false;
        }
        return true;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isCacheValid()) {
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inline: Box is open : " + box));
            }
            this.result = false;
            return false;
        }
        return box.getAppliedContentRefCount() != 0;
    }

    protected boolean startRowBox(RenderBox box) {
        if (!this.result) {
            return false;
        }
        if (box.isCacheValid()) {
            return false;
        }
        if (box.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Row: Box is open : " + box));
            }
            this.result = false;
            return false;
        }
        return box.getAppliedContentRefCount() != 0;
    }

    protected boolean startOtherBox(RenderBox box) {
        return this.result;
    }

    protected boolean isResult() {
        return this.result;
    }

    protected void setResult(boolean result) {
        this.result = result;
    }
}

