/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.AbstractAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineBoxSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.TextSequenceElement;

public final class CenterAlignmentProcessor
extends AbstractAlignmentProcessor {
    protected int handleElement(int start, int count) {
        long lastPageBreak;
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        RenderNode[] nodes = this.getNodes();
        long[] elementDimensions = this.getElementDimensions();
        long[] elementPositions = this.getElementPositions();
        int endIndex = start + count;
        long usedWidth = 0L;
        long usedWidthToStart = 0L;
        int contentIndex = start;
        InlineSequenceElement contentElement = null;
        for (int i = 0; i < endIndex; ++i) {
            InlineSequenceElement element = sequenceElements[i];
            RenderNode node = nodes[i];
            usedWidth += element.getMaximumWidth(node);
            if (i < start) {
                usedWidthToStart += element.getMaximumWidth(node);
            }
            if (element instanceof StartSequenceElement || element instanceof EndSequenceElement) continue;
            contentElement = element;
            contentIndex = i;
        }
        long nextPosition = this.getStartOfLine() + usedWidth;
        if (nextPosition > (lastPageBreak = this.getPageBreak(this.getPagebreakCount() - 1))) {
            this.performCenterAlignment(start, usedWidthToStart, sequenceElements, nodes, elementDimensions, elementPositions);
            if (contentElement instanceof TextSequenceElement) {
                this.setSkipIndex(endIndex);
                this.setBreakableIndex(contentIndex);
                return start;
            }
            if (start == 0) {
                RenderNode node;
                if (contentElement instanceof InlineBoxSequenceElement && ((node = nodes[contentIndex]).getNodeType() & 2) == 2) {
                    long contentPosition = elementPositions[contentIndex];
                    RenderBox box = (RenderBox)node;
                    long maxWidth = this.getEndOfLine() - contentPosition;
                    this.computeInlineBlock(box, contentPosition, maxWidth);
                    elementDimensions[endIndex - 1] = node.getCachedWidth();
                }
                this.setSkipIndex(endIndex);
            }
            return start;
        }
        if (this.performCenterAlignment(endIndex, usedWidth, sequenceElements, nodes, elementDimensions, elementPositions)) {
            return endIndex;
        }
        return start;
    }

    private boolean performCenterAlignment(int endIndex, long usedWidth, InlineSequenceElement[] sequenceElements, RenderNode[] nodes, long[] elementDimensions, long[] elementPositions) {
        int rightShiftStartIndex;
        int leftShiftEndIndex;
        long startOfLine = this.getStartOfLine();
        long totalWidth = this.getEndOfLine() - startOfLine;
        long emptySpace = Math.max(0L, totalWidth - usedWidth);
        long position = startOfLine + emptySpace / 2L;
        for (int i = 0; i < endIndex; ++i) {
            long elementWidth;
            RenderNode node = nodes[i];
            elementDimensions[i] = elementWidth = sequenceElements[i].getMaximumWidth(node);
            elementPositions[i] = position;
            position += elementWidth;
        }
        if (this.getPagebreakCount() == 1) {
            return true;
        }
        long centerPoint = startOfLine + totalWidth / 2L;
        int centerPageSegment = this.findStartOfPageSegmentForPosition(centerPoint);
        int centerPageSegmentNext = Math.min(this.getPagebreakCount() - 1, centerPageSegment + 1);
        long centerPageSegmentStart = this.getPageBreak(centerPageSegment);
        if (centerPageSegmentStart == centerPoint) {
            long centerElementEnd;
            int centerElement = this.findElementLeftOfPosition(centerPoint, endIndex);
            long centerElementPosition = elementPositions[centerElement];
            if (centerPoint - centerElementPosition > (centerElementEnd = centerElementPosition + elementDimensions[centerElement]) - centerPoint) {
                leftShiftEndIndex = centerElement + 1;
                rightShiftStartIndex = centerElement + 1;
            } else {
                leftShiftEndIndex = centerElement;
                rightShiftStartIndex = centerElement;
            }
        } else {
            long centerPageSegmentEnd;
            int rightElement;
            long elementPosition;
            long elementEnd;
            int leftElement;
            long elementPosition2;
            long elementEnd2;
            int endOfLineSegment = this.getPagebreakCount() - 1;
            boolean startOfLineSegment = false;
            leftShiftEndIndex = centerPageSegment > 0 ? ((elementEnd2 = (elementPosition2 = elementPositions[leftElement = this.findElementLeftOfPosition(centerPageSegmentStart, endIndex)]) + elementDimensions[leftElement]) < centerPageSegmentStart ? leftElement + 1 : leftElement) : 0;
            rightShiftStartIndex = centerPageSegment < endOfLineSegment ? ((elementEnd = (elementPosition = elementPositions[rightElement = this.findElementLeftOfPosition(centerPageSegmentEnd = this.getPageBreak(centerPageSegmentNext), endIndex)]) + elementDimensions[rightElement]) < centerPageSegmentEnd ? rightElement + 1 : rightElement) : endIndex;
        }
        long[] savedElementPos = (long[])elementPositions.clone();
        if (this.performShiftLeft(leftShiftEndIndex, centerPageSegment, savedElementPos) && this.performShiftRight(rightShiftStartIndex, endIndex, centerPageSegmentNext, savedElementPos)) {
            System.arraycopy(savedElementPos, 0, elementPositions, 0, savedElementPos.length);
            return true;
        }
        return false;
    }

    private boolean performShiftRight(int firstElementIndex, int lastElementIndex, int segment, long[] elementPositions) {
        if (firstElementIndex >= lastElementIndex) {
            return true;
        }
        long[] elementDimensions = this.getElementDimensions();
        long endOfLine = this.getEndOfLine();
        int pagebreakCount = this.getPagebreakCount();
        if (segment >= pagebreakCount) {
            return false;
        }
        long segmentEnd = this.getPageBreak(segment);
        long segmentStart = this.getStartOfSegment(segment);
        for (int i = firstElementIndex; i < lastElementIndex; ++i) {
            long elementWidth = elementDimensions[i];
            long elementEnd = segmentStart + elementWidth;
            if (elementEnd > endOfLine) {
                return false;
            }
            if (segment + 1 < pagebreakCount && elementEnd > segmentEnd) {
                segmentStart = segmentEnd;
                segmentEnd = this.getPageBreak(++segment);
                elementEnd = segmentStart + elementWidth;
            }
            if (elementEnd > endOfLine) {
                return false;
            }
            elementPositions[i] = segmentStart;
            segmentStart = elementEnd;
        }
        return true;
    }

    private boolean performShiftLeft(int lastElementIndex, int segment, long[] elementPositions) {
        if (lastElementIndex == 0) {
            return true;
        }
        long[] elementDimensions = this.getElementDimensions();
        int elementIdx = lastElementIndex - 1;
        long startOfLine = this.getStartOfLine();
        long segmentEnd = this.getPageBreak(segment);
        long segmentStart = this.getStartOfSegment(segment);
        for (int i = elementIdx; i >= 0; --i) {
            long elementWidth = elementDimensions[i];
            long elementStart = segmentEnd - elementWidth;
            if (elementStart < startOfLine) {
                return false;
            }
            while (segment > 0 && elementStart < segmentStart) {
                elementStart = segmentStart - elementWidth;
                segmentStart = this.getStartOfSegment(--segment);
            }
            if (elementStart < segmentStart) {
                return false;
            }
            elementPositions[i] = elementStart;
            segmentEnd = elementStart;
        }
        return true;
    }

    private long getStartOfSegment(int segment) {
        if (segment <= 0) {
            return this.getStartOfLine();
        }
        return this.getPageBreak(segment - 1);
    }

    private int findStartOfPageSegmentForPosition(long position) {
        int elementSize;
        long[] breaks = this.getPageBreaks();
        int i = CenterAlignmentProcessor.binarySearch(breaks, position, elementSize = this.getPagebreakCount());
        if (i > -1) {
            return i;
        }
        if (i == -1) {
            return 0;
        }
        return Math.min(-(i + 2), elementSize - 1);
    }

    private int findElementLeftOfPosition(long position, int endIndex) {
        long[] elementPositions = this.getElementPositions();
        int i = CenterAlignmentProcessor.binarySearch(elementPositions, position, endIndex);
        if (i > -1) {
            return i;
        }
        if (i == -1) {
            return 0;
        }
        return Math.min(-(i + 2), endIndex - 1);
    }

    private static int binarySearch(long[] array, long key, int end) {
        int low = 0;
        int high = end - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

