/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;

public class JustifyAlignmentProcessor
extends LeftAlignmentProcessor {
    protected int iterate(InlineSequenceElement[] elements, int maxPos) {
        int index = super.iterate(elements, maxPos);
        if (index <= 0) {
            return index;
        }
        this.performTextJustify(index);
        return index;
    }

    private void performTextJustify(int index) {
        long[] elementPositions = this.getElementPositions();
        long[] elementDimensions = this.getElementDimensions();
        int lastIndex = index - 1;
        long endPos = elementPositions[lastIndex] + elementDimensions[lastIndex];
        long extraSpace = Math.max(0L, this.getEndOfLine() - endPos);
        RenderNode[] nodes = this.getNodes();
        InlineSequenceElement[] sequenceElements = this.getSequenceElements();
        if (extraSpace > 0L && !this.isLastLineAlignment()) {
            long spacerCount = 0L;
            for (int i = 0; i < index; ++i) {
                InlineSequenceElement ise = sequenceElements[i];
                RenderNode node = nodes[i];
                if (node.getNodeType() != 65) continue;
                spacerCount += ise.getMaximumWidth(node);
            }
            if (spacerCount > 0L) {
                double extraSpacePerSpacerUnit = (double)extraSpace / (double)spacerCount;
                long shift = 0L;
                for (int i = 0; i < index; ++i) {
                    int n = i;
                    elementPositions[n] = elementPositions[n] + shift;
                    InlineSequenceElement ise = sequenceElements[i];
                    RenderNode node = nodes[i];
                    if (node.getNodeType() != 65) continue;
                    long width = ise.getMaximumWidth(node);
                    long extraSpaceHere = (long)(extraSpacePerSpacerUnit * (double)width);
                    int n2 = i;
                    elementDimensions[n2] = elementDimensions[n2] + extraSpaceHere;
                    shift += extraSpaceHere;
                }
            }
        }
    }
}

