/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.valign;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.AlignContext;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;

public final class BoxAlignContext
extends AlignContext {
    private long insetsTop;
    private long insetsBottom;
    private long[] baselines;
    private AlignContext firstChild;
    private AlignContext lastChild;
    private boolean simpleContext = true;

    public BoxAlignContext(RenderBox box) {
        super(box);
        long afterEdge;
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        ExtendedBaselineInfo baselineInfo = box.getBaselineInfo();
        if (baselineInfo == null) {
            baselineInfo = blp.getNominalBaselineInfo();
        }
        if (baselineInfo == null) {
            throw new IllegalStateException("A box that has no baseline info.");
        }
        int dominantBaselineValue = blp.getDominantBaseline();
        if (dominantBaselineValue == -1) {
            this.setDominantBaseline(baselineInfo.getDominantBaseline());
        } else {
            this.setDominantBaseline(dominantBaselineValue);
        }
        BoxDefinition bdef = box.getBoxDefinition();
        this.insetsTop = blp.getBorderTop() + bdef.getPaddingTop();
        this.insetsBottom = blp.getBorderBottom() + bdef.getPaddingBottom();
        this.baselines = baselineInfo.getBaselines();
        int length = this.baselines.length;
        int i = 1;
        while (i < length) {
            int n = i++;
            this.baselines[n] = this.baselines[n] + this.insetsTop;
        }
        this.baselines[9] = afterEdge = this.baselines[8] + this.insetsBottom;
    }

    public boolean isSimpleNode() {
        return this.simpleContext;
    }

    public void addChild(AlignContext context) {
        if (this.simpleContext && !context.isSimpleNode()) {
            this.simpleContext = false;
        }
        if (this.lastChild == null) {
            this.firstChild = context;
            this.lastChild = context;
            return;
        }
        this.lastChild.setNext(context);
        this.lastChild = context;
    }

    public AlignContext getFirstChild() {
        return this.firstChild;
    }

    public long getInsetsTop() {
        return this.insetsTop;
    }

    public long getInsetsBottom() {
        return this.insetsBottom;
    }

    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()];
    }

    public void shift(long delta) {
        int length = this.baselines.length;
        int i = 0;
        while (i < length) {
            int n = i++;
            this.baselines[n] = this.baselines[n] + delta;
        }
        for (AlignContext child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.shift(delta);
        }
    }

    public long getAfterEdge() {
        return this.baselines[9];
    }

    public long getBeforeEdge() {
        return this.baselines[0];
    }

    public void setBeforeEdge(long offset) {
        this.baselines[0] = offset;
    }

    public void setAfterEdge(long offset) {
        this.baselines[9] = offset;
    }

    public void validate() {
        if (!this.simpleContext) {
            return;
        }
        for (AlignContext child = this.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isSimpleNode()) {
                this.simpleContext = false;
                return;
            }
            if (this.getAfterEdge() != child.getAfterEdge()) {
                this.simpleContext = false;
                return;
            }
            if (this.getBeforeEdge() != child.getBeforeEdge()) {
                this.simpleContext = false;
                return;
            }
            int dominantBaseline = this.getDominantBaseline();
            if (dominantBaseline != child.getDominantBaseline()) {
                this.simpleContext = false;
                return;
            }
            if (this.getBaselineDistance(dominantBaseline) == child.getBaselineDistance(dominantBaseline)) continue;
            this.simpleContext = false;
            return;
        }
    }
}

