/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.valign;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.AlignContext;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;

public final class TextElementAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public TextElementAlignContext(RenderableText text) {
        super(text);
        ExtendedBaselineInfo baselineInfo = text.getBaselineInfo();
        this.baselines = baselineInfo.getBaselines();
        this.setDominantBaseline(baselineInfo.getDominantBaseline());
    }

    public boolean isSimpleNode() {
        return true;
    }

    public long getBaselineDistance(int baseline) {
        return this.baselines[baseline] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    public void shift(long delta) {
        this.baselineShift += delta;
    }

    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

