/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.valign;

import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.CacheBoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.InfiniteMajorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.AlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.BoxAlignContext;
import org.pentaho.reporting.engine.classic.core.layout.process.valign.InlineBlockAlignContext;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;

public final class VerticalAlignmentProcessor {
    private long minTopPos;
    private long maxBottomPos;
    private BoxAlignContext rootContext;
    private long sourcePosition;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;

    private InfiniteMajorAxisLayoutStep getMajorAxisLayoutStep() {
        if (this.majorAxisLayoutStep == null) {
            this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
        }
        return this.majorAxisLayoutStep;
    }

    public void align(BoxAlignContext alignStructure, long y1, long lineHeight) {
        this.minTopPos = Long.MAX_VALUE;
        this.maxBottomPos = Long.MIN_VALUE;
        this.rootContext = alignStructure;
        this.sourcePosition = y1;
        this.performAlignment(alignStructure);
        if (!alignStructure.isSimpleNode()) {
            this.performExtendedAlignment(alignStructure, alignStructure);
        }
        this.normalizeAlignment(alignStructure);
        alignStructure.setAfterEdge(Math.max(this.maxBottomPos, lineHeight));
        alignStructure.shift(-this.minTopPos + y1);
        this.apply(alignStructure);
        this.rootContext = null;
    }

    private void performAlignment(BoxAlignContext box) {
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            if (child instanceof InlineBlockAlignContext) {
                InlineBlockAlignContext context = (InlineBlockAlignContext)child;
                InfiniteMajorAxisLayoutStep majorAxisLayoutStep = this.getMajorAxisLayoutStep();
                majorAxisLayoutStep.continueComputation((RenderBox)context.getNode());
            }
            BoxAlignContext parent = box;
            VerticalTextAlign verticalAlignment = child.getNode().getVerticalTextAlignment();
            if (VerticalTextAlign.TOP.equals(verticalAlignment) || VerticalTextAlign.BOTTOM.equals(verticalAlignment)) {
                parent = this.rootContext;
            }
            long shiftDistance = this.computeShift(child, parent);
            int alignmentBaseline = child.getDominantBaseline();
            long childAlignmentPoint = this.computeAlignmentAdjust(child, alignmentBaseline);
            long childAscent = child.getBaselineDistance(0);
            long childPosition = -childAscent + childAlignmentPoint + child.getBeforeEdge();
            long parentAlignmentPoint = parent.getBaselineDistance(alignmentBaseline);
            long parentAscent = parent.getBaselineDistance(0);
            long parentPosition = -parentAscent + parentAlignmentPoint + parent.getBeforeEdge();
            long alignment = parentPosition - childPosition;
            long offset = shiftDistance + alignment;
            child.shift(offset);
            if (this.rootContext.getBeforeEdge() > child.getBeforeEdge()) {
                this.rootContext.setBeforeEdge(child.getBeforeEdge());
            }
            if (this.rootContext.getAfterEdge() < child.getAfterEdge()) {
                this.rootContext.setAfterEdge(child.getAfterEdge());
            }
            if (!(child instanceof BoxAlignContext)) continue;
            this.performAlignment((BoxAlignContext)child);
        }
    }

    private void normalizeAlignment(BoxAlignContext box) {
        this.minTopPos = Math.min(this.minTopPos, box.getBeforeEdge());
        this.maxBottomPos = Math.max(this.maxBottomPos, box.getAfterEdge());
        if (box.isSimpleNode()) {
            return;
        }
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            if (!(child instanceof BoxAlignContext)) continue;
            this.normalizeAlignment((BoxAlignContext)child);
        }
    }

    private long computeShift(AlignContext child, BoxAlignContext box) {
        return 0L;
    }

    private long computeAlignmentAdjust(AlignContext context, int defaultBaseLine) {
        return context.getBaselineDistance(defaultBaseLine);
    }

    private void apply(BoxAlignContext box) {
        RenderNode node = box.getNode();
        long beforeEdge = box.getBeforeEdge();
        node.setCachedY(beforeEdge);
        node.setCachedHeight(box.getAfterEdge() - beforeEdge);
        if (box.isSimpleNode()) {
            for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
                if (child instanceof BoxAlignContext) {
                    this.apply((BoxAlignContext)child);
                    continue;
                }
                RenderNode childNode = child.getNode();
                long childBeforeEdge = child.getBeforeEdge();
                childNode.setCachedY(childBeforeEdge);
                childNode.setCachedHeight(child.getAfterEdge() - childBeforeEdge);
            }
        } else {
            for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
                if (child instanceof BoxAlignContext) {
                    this.apply((BoxAlignContext)child);
                    continue;
                }
                if (child instanceof InlineBlockAlignContext) {
                    long shift = child.getBeforeEdge() - this.sourcePosition;
                    CacheBoxShifter.shiftBox(child.getNode(), shift);
                    continue;
                }
                RenderNode childNode = child.getNode();
                long childBeforeEdge = child.getBeforeEdge();
                childNode.setCachedY(childBeforeEdge);
                childNode.setCachedHeight(child.getAfterEdge() - childBeforeEdge);
            }
        }
    }

    private void performExtendedAlignment(BoxAlignContext box, BoxAlignContext lineBox) {
        for (AlignContext child = box.getFirstChild(); child != null; child = child.getNext()) {
            ElementAlignment verticalAlignment = child.getNode().getNodeLayoutProperties().getVerticalAlignment();
            if (ElementAlignment.TOP.equals(verticalAlignment)) {
                long childTopEdge = child.getBeforeEdge();
                long parentTopEdge = lineBox.getBeforeEdge();
                child.shift(parentTopEdge - childTopEdge);
            } else if (ElementAlignment.BOTTOM.equals(verticalAlignment)) {
                long childBottomEdge = child.getAfterEdge();
                long parentBottomEdge = lineBox.getAfterEdge();
                child.shift(parentBottomEdge - childBottomEdge);
            }
            if (!(child instanceof BoxAlignContext)) continue;
            this.performExtendedAlignment((BoxAlignContext)child, lineBox);
        }
    }
}

