/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.richtext;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverter;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterUtilities;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;

public class HtmlRichTextConverter
implements RichTextConverter {
    private HTMLEditorKit editorKit = new HTMLEditorKit();
    private static final Set BLOCK_ELEMENTS;

    public boolean isRecognizedType(String mimeType) {
        return "text/html".equals(mimeType);
    }

    public Object convert(Element source, Object value) {
        try {
            Document doc = RichTextConverterUtilities.parseDocument(this.editorKit, value);
            if (doc == null) {
                return value;
            }
            Element element = this.process(doc.getDefaultRootElement());
            return RichTextConverterUtilities.convertToBand(StyleKey.getDefinedStyleKeys(), source, element);
        }
        catch (Exception e) {
            return value;
        }
    }

    private static AttributeSet computeStyle(javax.swing.text.Element elem, StyleSheet styles) {
        Object o;
        AttributeSet a = elem.getAttributes();
        AttributeSet htmlAttr = styles.translateHTMLToCSS(a);
        ArrayList<AttributeSet> muxList = new ArrayList<AttributeSet>();
        if (htmlAttr.getAttributeCount() != 0) {
            muxList.add(htmlAttr);
        }
        if (elem.isLeaf()) {
            Enumeration<?> keys = a.getAttributeNames();
            while (keys.hasMoreElements()) {
                Style cssRule;
                AttributeSet attr;
                Object key = keys.nextElement();
                if (!(key instanceof HTML.Tag) || key == HTML.Tag.A && (o = a.getAttribute(key)) instanceof AttributeSet && (attr = (AttributeSet)o).getAttribute(HTML.Attribute.HREF) == null || (cssRule = styles.getRule((HTML.Tag)key, elem)) == null) continue;
                muxList.add(cssRule);
            }
        } else {
            HTML.Tag t = (HTML.Tag)a.getAttribute(StyleConstants.NameAttribute);
            Style cssRule = styles.getRule(t, elem);
            if (cssRule != null) {
                muxList.add(cssRule);
            }
        }
        SimpleAttributeSet retval = new SimpleAttributeSet();
        for (int i = muxList.size() - 1; i >= 0; --i) {
            o = (AttributeSet)muxList.get(i);
            retval.addAttributes((AttributeSet)o);
        }
        return retval;
    }

    private Object convertURL(String srcAttr) {
        try {
            return new URL(srcAttr);
        }
        catch (MalformedURLException e) {
            return srcAttr;
        }
    }

    private Element process(javax.swing.text.Element textElement) throws BadLocationException {
        if (this.isInvisible(textElement)) {
            return null;
        }
        if (textElement.isLeaf()) {
            AttributeSet attributes = textElement.getAttributes();
            if (HTML.Tag.IMG.equals(attributes.getAttribute(StyleConstants.NameAttribute))) {
                Element result = new Element();
                result.setName(textElement.getName());
                result.setElementType(ContentType.INSTANCE);
                String src = (String)attributes.getAttribute(HTML.Attribute.SRC);
                String alt = (String)attributes.getAttribute(HTML.Attribute.TITLE);
                result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.convertURL(src));
                result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "title", alt);
                result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "tooltip", alt);
                if (attributes.isDefined(HTML.Attribute.WIDTH) && attributes.isDefined(HTML.Attribute.HEIGHT)) {
                    result.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.FALSE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, this.parseLength(String.valueOf(attributes.getAttribute(HTML.Attribute.WIDTH))));
                    result.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, this.parseLength(String.valueOf(attributes.getAttribute(HTML.Attribute.HEIGHT))));
                } else if (attributes.isDefined(HTML.Attribute.WIDTH)) {
                    result.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, this.parseLength(String.valueOf(attributes.getAttribute(HTML.Attribute.WIDTH))));
                    result.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
                } else if (attributes.isDefined(HTML.Attribute.HEIGHT)) {
                    result.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, this.parseLength(String.valueOf(attributes.getAttribute(HTML.Attribute.HEIGHT))));
                    result.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
                } else {
                    result.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.FALSE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.TRUE);
                    result.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, Boolean.TRUE);
                }
                this.configureStyle(textElement, result);
                return result;
            }
            javax.swing.text.Element parent = textElement.getParentElement();
            int endOffset = textElement.getEndOffset();
            int startOffset = textElement.getStartOffset();
            String text = textElement.getDocument().getText(startOffset, endOffset - startOffset);
            if (parent != null) {
                HTML.Tag tag = this.findTag(parent.getAttributes());
                if ("\n".equals(text) && (BLOCK_ELEMENTS.contains(tag) || "paragraph".equals(textElement.getName()) || "section".equals(textElement.getName())) && parent.getElementCount() > 0 && parent.getElement(parent.getElementCount() - 1) == textElement) {
                    return null;
                }
            }
            Element result = new Element();
            result.setName(textElement.getName());
            result.setElementType(LabelType.INSTANCE);
            result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", text);
            this.configureStyle(textElement, result);
            if (HTML.Tag.BR.equals(textElement.getAttributes().getAttribute(StyleConstants.NameAttribute))) {
                result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", "\n");
                result.getStyle().setStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT, Boolean.FALSE);
                result.getStyle().setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.PRESERVE);
            }
            return result;
        }
        Band band = new Band();
        this.configureStyle(textElement, band);
        this.configureBand(textElement, band);
        boolean bandIsInline = this.isInlineElement(band);
        int size = textElement.getElementCount();
        Band inlineContainer = null;
        for (int i = 0; i < size; ++i) {
            Element element = this.process(textElement.getElement(i));
            if (element == null) continue;
            if (this.isInlineElement(element) == bandIsInline) {
                band.addElement(element);
                continue;
            }
            if (band.getElementCount() == 0) {
                inlineContainer = new Band();
                inlineContainer.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
                inlineContainer.addElement(element);
                band.addElement(inlineContainer);
                continue;
            }
            Element maybeInlineContainer = (Element)band.getElement(band.getElementCount() - 1);
            if (maybeInlineContainer == inlineContainer) {
                inlineContainer.addElement(element);
                continue;
            }
            inlineContainer = new Band();
            inlineContainer.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
            inlineContainer.addElement(element);
            band.addElement(inlineContainer);
        }
        return band;
    }

    private boolean isInlineElement(Element element) {
        if (element instanceof Band) {
            return "inline".equals(element.getStyle().getStyleProperty(BandStyleKeys.LAYOUT, "inline"));
        }
        return true;
    }

    private boolean isInvisible(javax.swing.text.Element textElement) {
        HTMLDocument htmlDocument = (HTMLDocument)textElement.getDocument();
        StyleSheet sheet = htmlDocument.getStyleSheet();
        AttributeSet attr = HtmlRichTextConverter.computeStyle(textElement, sheet);
        Object o = attr.getAttribute(CSS.Attribute.DISPLAY);
        if ("none".equals(String.valueOf(o))) {
            return true;
        }
        HTML.Tag tag = this.findTag(textElement.getAttributes());
        if (tag == HTML.Tag.COMMENT) {
            return true;
        }
        if (tag == HTML.Tag.SCRIPT) {
            return true;
        }
        return tag == HTML.Tag.HEAD;
    }

    private void configureStyle(javax.swing.text.Element textElement, Element result) {
        Object textIndentStyle;
        Object titleAttribute;
        Object whitespaceText;
        Object valign;
        String value;
        Object textDecoration;
        Object textAlign;
        Object lineHeight;
        Object wordSpacing;
        Object letterSpacing;
        HTMLDocument htmlDocument = (HTMLDocument)textElement.getDocument();
        StyleSheet sheet = htmlDocument.getStyleSheet();
        AttributeSet attr = HtmlRichTextConverter.computeStyle(textElement, sheet);
        this.parseBorderAndBackgroundStyle(result, sheet, attr);
        this.parseBoxStyle(result, attr);
        Font font = sheet.getFont(attr);
        if (font != null) {
            result.getStyle().setStyleProperty(TextStyleKeys.FONT, font.getFamily());
            result.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, new Integer(font.getSize()));
            result.getStyle().setBooleanStyleProperty(TextStyleKeys.ITALIC, font.isItalic());
            result.getStyle().setBooleanStyleProperty(TextStyleKeys.BOLD, font.isBold());
        }
        if ((letterSpacing = attr.getAttribute(CSS.Attribute.LETTER_SPACING)) != null) {
            result.getStyle().setStyleProperty(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, this.parseLength(String.valueOf(letterSpacing)));
        }
        if ((wordSpacing = attr.getAttribute(CSS.Attribute.WORD_SPACING)) != null) {
            result.getStyle().setStyleProperty(TextStyleKeys.WORD_SPACING, this.parseLength(String.valueOf(wordSpacing)));
        }
        if ((lineHeight = attr.getAttribute(CSS.Attribute.LINE_HEIGHT)) != null) {
            result.getStyle().setStyleProperty(TextStyleKeys.LINEHEIGHT, this.parseLength(String.valueOf(lineHeight)));
        }
        if ((textAlign = attr.getAttribute(CSS.Attribute.TEXT_ALIGN)) != null) {
            try {
                result.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ReportParserUtil.parseHorizontalElementAlignment(String.valueOf(textAlign), null));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((textDecoration = attr.getAttribute(CSS.Attribute.TEXT_DECORATION)) != null) {
            String[] strings = StringUtils.split((String)String.valueOf(textDecoration));
            result.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, Boolean.FALSE);
            result.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, Boolean.FALSE);
            for (int i = 0; i < strings.length; ++i) {
                value = strings[i];
                if ("line-through".equals(value)) {
                    result.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, Boolean.TRUE);
                }
                if (!"underline".equals(value)) continue;
                result.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, Boolean.TRUE);
            }
        }
        if ((valign = attr.getAttribute(CSS.Attribute.VERTICAL_ALIGN)) != null) {
            VerticalTextAlign valignValue = VerticalTextAlign.valueOf(String.valueOf(valign));
            result.getStyle().setStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT, valignValue);
            try {
                result.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, ReportParserUtil.parseVerticalElementAlignment(String.valueOf(valign), null));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((whitespaceText = attr.getAttribute(CSS.Attribute.WHITE_SPACE)) != null) {
            value = String.valueOf(whitespaceText);
            if ("pre".equals(value)) {
                result.getStyle().setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.PRESERVE);
                result.getStyle().setStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.NONE);
            } else if ("nowrap".equals(value)) {
                result.getStyle().setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.PRESERVE_BREAKS);
                result.getStyle().setStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.NONE);
            } else {
                result.getStyle().setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.COLLAPSE);
                result.getStyle().setStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.WRAP);
            }
        } else {
            result.getStyle().setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, WhitespaceCollapse.COLLAPSE);
            result.getStyle().setStyleProperty(TextStyleKeys.TEXT_WRAP, TextWrap.WRAP);
        }
        Object alignAttribute = attr.getAttribute(HTML.Attribute.ALIGN);
        if (alignAttribute != null) {
            try {
                result.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, ReportParserUtil.parseHorizontalElementAlignment(String.valueOf(alignAttribute), null));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((titleAttribute = attr.getAttribute(HTML.Attribute.TITLE)) != null) {
            result.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "title", String.valueOf(titleAttribute));
        }
        if ((textIndentStyle = attr.getAttribute(CSS.Attribute.TEXT_INDENT)) != null) {
            result.getStyle().setStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, this.parseLength(String.valueOf(textIndentStyle)));
        }
    }

    private HTML.Tag findTag(AttributeSet attr) {
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            Object o = attr.getAttribute(name);
            if (!(o instanceof HTML.Tag) || HTML.Tag.CONTENT == o || HTML.Tag.COMMENT == o) continue;
            return (HTML.Tag)o;
        }
        return null;
    }

    private void parseBoxStyle(Element result, AttributeSet attr) {
        Object widthText;
        Object heightText;
        Object paddingRight;
        Object paddingBottom;
        Object paddingLeft;
        Object paddingTop;
        Object paddingText = attr.getAttribute(CSS.Attribute.PADDING);
        if (paddingText != null) {
            Float padding = this.parseLength(String.valueOf(paddingText));
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_TOP, padding);
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_LEFT, padding);
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, padding);
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_RIGHT, padding);
        }
        if ((paddingTop = attr.getAttribute(CSS.Attribute.PADDING_TOP)) != null) {
            Float padding = this.parseLength(String.valueOf(paddingTop));
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_TOP, padding);
        }
        if ((paddingLeft = attr.getAttribute(CSS.Attribute.PADDING_LEFT)) != null) {
            Float padding = this.parseLength(String.valueOf(paddingLeft));
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_LEFT, padding);
        }
        if ((paddingBottom = attr.getAttribute(CSS.Attribute.PADDING_BOTTOM)) != null) {
            Float padding = this.parseLength(String.valueOf(paddingBottom));
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, padding);
        }
        if ((paddingRight = attr.getAttribute(CSS.Attribute.PADDING_RIGHT)) != null) {
            Float padding = this.parseLength(String.valueOf(paddingRight));
            result.getStyle().setStyleProperty(ElementStyleKeys.PADDING_RIGHT, padding);
        }
        if ((heightText = attr.getAttribute(CSS.Attribute.HEIGHT)) != null) {
            result.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, this.parseLength(String.valueOf(heightText)));
        }
        if ((widthText = attr.getAttribute(CSS.Attribute.WIDTH)) != null) {
            result.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, this.parseLength(String.valueOf(widthText)));
        }
    }

    private void parseBorderAndBackgroundStyle(Element result, StyleSheet sheet, AttributeSet attr) {
        Object borderColorText;
        Object colorText;
        Object borderLeftWidth;
        Object borderTopWidthText;
        Object borderRightWidthText;
        Object borderBottomWidthText;
        Object borderWidthText;
        BorderStyle borderStyle;
        Object borderStyleText;
        Object backgroundColor = attr.getAttribute(CSS.Attribute.BACKGROUND_COLOR);
        if (backgroundColor != null) {
            result.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, sheet.stringToColor(String.valueOf(backgroundColor)));
        }
        if ((borderStyleText = attr.getAttribute(CSS.Attribute.BORDER_STYLE)) != null && (borderStyle = BorderStyle.getBorderStyle(String.valueOf(borderStyleText))) != null) {
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, borderStyle);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, borderStyle);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, borderStyle);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, borderStyle);
        }
        if ((borderWidthText = attr.getAttribute(CSS.Attribute.BORDER_WIDTH)) != null) {
            Float borderWidth = this.parseLength(String.valueOf(borderWidthText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, borderWidth);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, borderWidth);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, borderWidth);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, borderWidth);
        }
        if ((borderBottomWidthText = attr.getAttribute(CSS.Attribute.BORDER_BOTTOM_WIDTH)) != null) {
            Float borderWidth = this.parseLength(String.valueOf(borderBottomWidthText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, borderWidth);
        }
        if ((borderRightWidthText = attr.getAttribute(CSS.Attribute.BORDER_RIGHT_WIDTH)) != null) {
            Float borderWidth = this.parseLength(String.valueOf(borderRightWidthText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, borderWidth);
        }
        if ((borderTopWidthText = attr.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH)) != null) {
            Float borderWidth = this.parseLength(String.valueOf(borderTopWidthText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, borderWidth);
        }
        if ((borderLeftWidth = attr.getAttribute(CSS.Attribute.BORDER_LEFT_WIDTH)) != null) {
            Float borderWidth = this.parseLength(String.valueOf(borderLeftWidth));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, borderWidth);
        }
        if ((colorText = attr.getAttribute(CSS.Attribute.COLOR)) != null) {
            Color color = sheet.stringToColor(String.valueOf(colorText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, color);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, color);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, color);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, color);
            result.getStyle().setStyleProperty(ElementStyleKeys.PAINT, color);
        }
        if ((borderColorText = attr.getAttribute(CSS.Attribute.BORDER_COLOR)) != null) {
            Color borderColor = sheet.stringToColor(String.valueOf(borderColorText));
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, borderColor);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, borderColor);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, borderColor);
            result.getStyle().setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, borderColor);
        }
    }

    private Float parseLength(String value) {
        if (value == null) {
            return null;
        }
        try {
            StreamTokenizer strtok = new StreamTokenizer(new StringReader(value));
            strtok.parseNumbers();
            int firstToken = strtok.nextToken();
            if (firstToken != -2) {
                return null;
            }
            double nval = strtok.nval;
            int nextToken = strtok.nextToken();
            if (nextToken != -3) {
                return new Float(nval);
            }
            String unit = strtok.sval;
            if ("%".equals(unit)) {
                return new Float(-nval);
            }
            if ("cm".equals(unit)) {
                return new Float(nval * 25.4 / 72.0);
            }
            if ("mm".equals(unit)) {
                return new Float(nval * 2.54 / 72.0);
            }
            if ("pt".equals(unit)) {
                return new Float(nval);
            }
            if ("in".equals(unit)) {
                return new Float(nval * 72.0);
            }
            if ("px".equals(unit)) {
                return new Float(nval * 72.0);
            }
            if ("pc".equals(unit)) {
                return new Float(nval * 12.0);
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void configureBand(javax.swing.text.Element textElement, Band band) {
        HTML.Tag tag = this.findTag(textElement.getAttributes());
        if (tag == null) {
            if ("paragraph".equals(textElement.getName()) || "section".equals(textElement.getName())) {
                band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
                band.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(-100.0f));
                band.setName(textElement.getName());
            } else {
                band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
                band.setName(textElement.getName());
            }
            return;
        }
        if (BLOCK_ELEMENTS.contains(tag)) {
            band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
            band.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(-100.0f));
            band.setName(String.valueOf(tag));
        } else {
            band.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "inline");
            band.setName(String.valueOf(tag));
        }
    }

    static {
        HashSet<HTML.Tag> blockElements = new HashSet<HTML.Tag>();
        blockElements.add(HTML.Tag.IMPLIED);
        blockElements.add(HTML.Tag.APPLET);
        blockElements.add(HTML.Tag.BODY);
        blockElements.add(HTML.Tag.BLOCKQUOTE);
        blockElements.add(HTML.Tag.DIV);
        blockElements.add(HTML.Tag.FORM);
        blockElements.add(HTML.Tag.FRAME);
        blockElements.add(HTML.Tag.FRAMESET);
        blockElements.add(HTML.Tag.H1);
        blockElements.add(HTML.Tag.H2);
        blockElements.add(HTML.Tag.H3);
        blockElements.add(HTML.Tag.H4);
        blockElements.add(HTML.Tag.H5);
        blockElements.add(HTML.Tag.H6);
        blockElements.add(HTML.Tag.HR);
        blockElements.add(HTML.Tag.HTML);
        blockElements.add(HTML.Tag.LI);
        blockElements.add(HTML.Tag.NOFRAMES);
        blockElements.add(HTML.Tag.OBJECT);
        blockElements.add(HTML.Tag.OL);
        blockElements.add(HTML.Tag.P);
        blockElements.add(HTML.Tag.PRE);
        blockElements.add(HTML.Tag.TABLE);
        blockElements.add(HTML.Tag.TR);
        blockElements.add(HTML.Tag.UL);
        BLOCK_ELEMENTS = Collections.unmodifiableSet(blockElements);
    }
}

