/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class CanvasMinWidthStyleSheet
extends AbstractStyleSheet {
    private StyleSheet parent;
    private Float minWidth;

    public CanvasMinWidthStyleSheet(StyleSheet parent) {
        this.parent = parent;
        this.minWidth = (Float)parent.getStyleProperty(ElementStyleKeys.MIN_WIDTH);
        if (this.minWidth.floatValue() == 0.0f) {
            this.minWidth = new Float(-100.0f);
        }
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public InstanceID getId() {
        return this.parent.getId();
    }

    public long getChangeTracker() {
        return this.parent.getChangeTracker();
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (ElementStyleKeys.MINIMUMSIZE.equals(key)) {
            Float maxHeight = (Float)this.parent.getStyleProperty(ElementStyleKeys.MIN_HEIGHT);
            return new FloatDimension(this.minWidth.floatValue(), maxHeight.floatValue());
        }
        if (ElementStyleKeys.MIN_WIDTH.equals(key)) {
            return this.minWidth;
        }
        return this.parent.getStyleProperty(key, defaultValue);
    }

    public Object[] toArray() {
        Object[] objects = this.parent.toArray();
        objects[ElementStyleKeys.MINIMUMSIZE.getIdentifier()] = null;
        objects[ElementStyleKeys.MIN_WIDTH.getIdentifier()] = this.minWidth;
        return objects;
    }
}

