/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class DynamicHeightWrapperStyleSheet
extends AbstractStyleSheet {
    private StyleSheet parent;
    private Float minWidth;

    public DynamicHeightWrapperStyleSheet(StyleSheet parent) {
        this.parent = parent;
        this.minWidth = (Float)parent.getStyleProperty(ElementStyleKeys.MIN_WIDTH);
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public InstanceID getId() {
        return this.parent.getId();
    }

    public long getChangeTracker() {
        return this.parent.getChangeTracker();
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (ElementStyleKeys.MAXIMUMSIZE.equals(key)) {
            Float maxHeight = (Float)this.parent.getStyleProperty(ElementStyleKeys.MAX_HEIGHT);
            return new FloatDimension(this.minWidth.floatValue(), maxHeight.floatValue());
        }
        if (ElementStyleKeys.MAX_WIDTH.equals(key)) {
            return this.parent.getStyleProperty(ElementStyleKeys.MIN_WIDTH, defaultValue);
        }
        return this.parent.getStyleProperty(key, defaultValue);
    }

    public Object[] toArray() {
        Object[] objects = this.parent.toArray();
        objects[ElementStyleKeys.MAXIMUMSIZE.getIdentifier()] = null;
        objects[ElementStyleKeys.MAX_WIDTH.getIdentifier()] = objects[ElementStyleKeys.MIN_WIDTH.getIdentifier()];
        return objects;
    }
}

