/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import java.awt.geom.Point2D;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class DynamicReplacedContentStyleSheet
extends AbstractStyleSheet {
    private static final Float SIZE = new Float(-100.0f);
    private static final Float POS = new Float(0.0f);
    private StyleSheet parent;

    public DynamicReplacedContentStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public InstanceID getId() {
        return this.parent.getId();
    }

    public long getChangeTracker() {
        return this.parent.getChangeTracker();
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (ElementStyleKeys.MINIMUMSIZE.equals(key)) {
            return new FloatDimension(-100.0f, -100.0f);
        }
        if (ElementStyleKeys.MIN_WIDTH.equals(key)) {
            return SIZE;
        }
        if (ElementStyleKeys.MIN_HEIGHT.equals(key)) {
            return SIZE;
        }
        if (ElementStyleKeys.POS_X.equals(key)) {
            return POS;
        }
        if (ElementStyleKeys.POS_Y.equals(key)) {
            return POS;
        }
        if (ElementStyleKeys.ABSOLUTE_POS.equals(key)) {
            return new Point2D.Float(0.0f, 0.0f);
        }
        return this.parent.getStyleProperty(key, defaultValue);
    }

    public Object[] toArray() {
        Object[] objects = this.parent.toArray();
        objects[ElementStyleKeys.MIN_WIDTH.getIdentifier()] = SIZE;
        objects[ElementStyleKeys.MIN_HEIGHT.getIdentifier()] = SIZE;
        objects[ElementStyleKeys.MINIMUMSIZE.getIdentifier()] = null;
        objects[ElementStyleKeys.POS_X.getIdentifier()] = POS;
        objects[ElementStyleKeys.POS_Y.getIdentifier()] = POS;
        objects[ElementStyleKeys.ABSOLUTE_POS.getIdentifier()] = null;
        return objects;
    }
}

