/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import java.awt.geom.Point2D;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FloatDimension;

public class ManualBreakIndicatorStyleSheet
extends AbstractStyleSheet {
    private static final Float WIDTH = new Float(-100.0f);
    private static final Float ZERO = new Float(0.0f);
    private StyleSheet parent;

    public ManualBreakIndicatorStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public InstanceID getId() {
        return this.parent.getId();
    }

    public long getChangeTracker() {
        return this.parent.getChangeTracker();
    }

    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (ElementStyleKeys.MINIMUMSIZE.equals(key)) {
            return new FloatDimension(-100.0f, 0.0f);
        }
        if (ElementStyleKeys.MIN_WIDTH.equals(key)) {
            return WIDTH;
        }
        if (ElementStyleKeys.MIN_HEIGHT.equals(key)) {
            return ZERO;
        }
        if (ElementStyleKeys.POS_X.equals(key)) {
            return ZERO;
        }
        if (ElementStyleKeys.POS_Y.equals(key)) {
            return ZERO;
        }
        if (ElementStyleKeys.ABSOLUTE_POS.equals(key)) {
            return new Point2D.Float(0.0f, 0.0f);
        }
        if (BandStyleKeys.PAGEBREAK_BEFORE.equals(key)) {
            return Boolean.TRUE;
        }
        return this.parent.getStyleProperty(key, defaultValue);
    }

    public Object[] toArray() {
        Object[] objects = this.parent.toArray();
        objects[ElementStyleKeys.MIN_WIDTH.getIdentifier()] = WIDTH;
        objects[ElementStyleKeys.MIN_HEIGHT.getIdentifier()] = WIDTH;
        objects[ElementStyleKeys.MINIMUMSIZE.getIdentifier()] = null;
        objects[ElementStyleKeys.POS_X.getIdentifier()] = ZERO;
        objects[ElementStyleKeys.POS_Y.getIdentifier()] = ZERO;
        objects[ElementStyleKeys.ABSOLUTE_POS.getIdentifier()] = null;
        objects[BandStyleKeys.PAGEBREAK_BEFORE.getIdentifier()] = Boolean.TRUE;
        return objects;
    }
}

