/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class AbstractMetaData
implements Serializable,
MetaData {
    private transient Image[] icons;
    private String name;
    private String bundleLocation;
    private String keyPrefix;
    private boolean expert;
    private boolean preferred;
    private boolean hidden;
    private boolean deprecated;
    private transient Locale lastLocale;
    private transient Messages lastMessages;
    private String displayNameKey;
    private String descriptionKey;
    private String groupingKey;
    private String groupingOrdinalKey;
    private String itemOrdinalKey;
    private String keyPrefixAndName;
    private final String deprecationKey;
    private boolean experimental;
    private int compatibilityLevel;

    public AbstractMetaData(String name, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated) {
        this(name, bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, false, -1);
    }

    public AbstractMetaData(String name, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean experimental, int compatibilityLevel) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (bundleLocation == null) {
            throw new NullPointerException();
        }
        if (keyPrefix == null) {
            throw new NullPointerException();
        }
        this.compatibilityLevel = compatibilityLevel;
        this.experimental = experimental;
        this.name = name;
        this.bundleLocation = bundleLocation;
        this.keyPrefix = keyPrefix;
        this.expert = expert;
        this.preferred = preferred;
        this.hidden = hidden;
        this.deprecated = deprecated;
        this.keyPrefixAndName = this.computePrefix(this.keyPrefix, this.name);
        if (StringUtils.isEmpty((String)this.keyPrefixAndName, (boolean)true)) {
            this.displayNameKey = "display-name";
            this.descriptionKey = "description";
            this.itemOrdinalKey = "ordinal";
            this.groupingKey = "grouping";
            this.groupingOrdinalKey = "grouping.ordinal";
            this.deprecationKey = "deprecated";
        } else {
            this.displayNameKey = this.keyPrefixAndName + ".display-name";
            this.descriptionKey = this.keyPrefixAndName + ".description";
            this.itemOrdinalKey = this.keyPrefixAndName + ".ordinal";
            this.groupingKey = this.keyPrefixAndName + ".grouping";
            this.groupingOrdinalKey = this.keyPrefixAndName + ".grouping.ordinal";
            this.deprecationKey = this.keyPrefixAndName + ".deprecated";
        }
    }

    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    protected String computePrefix(String keyPrefix, String name) {
        return keyPrefix + name;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getName() {
        return this.name;
    }

    public Messages getBundle(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.lastMessages == null || !ObjectUtilities.equal((Object)locale, (Object)this.lastLocale)) {
            this.lastMessages = new Messages(locale, this.bundleLocation, ObjectUtilities.getClassLoader(AbstractMetaData.class));
            this.lastLocale = locale;
        }
        return this.lastMessages;
    }

    public String getMetaAttribute(String attributeName, Locale locale) {
        try {
            String key = StringUtils.isEmpty((String)this.keyPrefixAndName) ? attributeName : this.keyPrefixAndName + '.' + attributeName;
            return this.getBundle(locale).strictString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public String getDisplayName(Locale locale) {
        return this.getBundle(locale).getString(this.displayNameKey);
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString(this.descriptionKey);
    }

    public String getGrouping(Locale locale) {
        return this.getBundle(locale).getString(this.groupingKey);
    }

    public int getGroupingOrdinal(Locale locale) {
        String strOrd = this.getBundle(locale).getString(this.groupingOrdinalKey);
        return ParserUtil.parseInt((String)strOrd, (int)Integer.MAX_VALUE);
    }

    public int getItemOrdinal(Locale locale) {
        String strOrd = this.getBundle(locale).getString(this.itemOrdinalKey);
        return ParserUtil.parseInt((String)strOrd, (int)Integer.MAX_VALUE);
    }

    public String getDeprecationMessage(Locale locale) {
        return this.getBundle(locale).getString(this.deprecationKey);
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public String getBundleLocation() {
        return this.bundleLocation;
    }

    public synchronized Image getIcon(Locale locale, int iconKind) {
        Image retval;
        String iconKey;
        block20: {
            block19: {
                Image cachedIcon;
                if (iconKind < 1 || iconKind > 4) {
                    throw new IllegalArgumentException();
                }
                if (this.icons != null && (cachedIcon = this.icons[iconKind - 1]) != null) {
                    return cachedIcon;
                }
                if (StringUtils.isEmpty((String)this.keyPrefixAndName)) break block19;
                switch (iconKind) {
                    case 1: {
                        iconKey = this.keyPrefixAndName + ".icon-color-16";
                        break block20;
                    }
                    case 2: {
                        iconKey = this.keyPrefixAndName + ".icon-color-32";
                        break block20;
                    }
                    case 3: {
                        iconKey = this.keyPrefixAndName + ".icon-mono-16";
                        break block20;
                    }
                    case 4: {
                        iconKey = this.keyPrefixAndName + ".icon-mono-32";
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            switch (iconKind) {
                case 1: {
                    iconKey = "icon-color-16";
                    break;
                }
                case 2: {
                    iconKey = "icon-color-32";
                    break;
                }
                case 3: {
                    iconKey = "icon-mono-16";
                    break;
                }
                case 4: {
                    iconKey = "icon-mono-32";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        URL url = null;
        String iconName = this.getOptionalString(locale, iconKey);
        if (iconName != null) {
            url = ObjectUtilities.getResource((String)iconName, DefaultElementMetaData.class);
        }
        if (url == null) {
            String fallbackIcon = this.getOptionalString(locale, this.getKeyPrefix() + this.getName() + ".icon");
            if (fallbackIcon != null) {
                url = ObjectUtilities.getResource((String)fallbackIcon, DefaultElementMetaData.class);
            }
            if (url == null) {
                return null;
            }
        }
        if (this.icons == null) {
            this.icons = new Image[4];
        }
        this.icons[iconKind - 1] = retval = Toolkit.getDefaultToolkit().createImage(url);
        return retval;
    }

    private String getOptionalString(Locale locale, String key) {
        try {
            return this.getBundle(locale).getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

