/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.metadata.parser.DataFactoryMetaDataCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataFactoryRegistry {
    private static final Log logger = LogFactory.getLog(DataFactoryRegistry.class);
    private static DataFactoryRegistry instance;
    private HashMap backend = new HashMap();

    public static synchronized DataFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new DataFactoryRegistry();
        }
        return instance;
    }

    private DataFactoryRegistry() {
    }

    public void registerFromXml(URL dataFactoryMetaSource) throws IOException {
        if (dataFactoryMetaSource == null) {
            throw new NullPointerException("Error: Could not find the data-factory meta-data description file");
        }
        try {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            Resource resource = resourceManager.createDirectly((Object)dataFactoryMetaSource, DataFactoryMetaDataCollection.class);
            DataFactoryMetaDataCollection typeCollection = (DataFactoryMetaDataCollection)resource.getResource();
            DataFactoryMetaData[] types = typeCollection.getFactoryMetaData();
            for (int i = 0; i < types.length; ++i) {
                DataFactoryMetaData metaData = types[i];
                if (metaData == null) continue;
                DataFactoryRegistry.getInstance().register(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public void register(DataFactoryMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.backend.put(metaData.getName(), metaData);
    }

    public DataFactoryMetaData[] getAll() {
        return this.backend.values().toArray(new DataFactoryMetaData[this.backend.size()]);
    }

    public boolean isRegistered(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        return this.backend.containsKey(identifier);
    }

    public DataFactoryMetaData getMetaData(String identifier) throws MetaDataLookupException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        DataFactoryMetaData retval = (DataFactoryMetaData)this.backend.get(identifier);
        if (retval == null) {
            throw new MetaDataLookupException("Unable to locate metadata for data-factory type " + identifier);
        }
        return retval;
    }
}

