/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultElementMetaData
extends AbstractMetaData
implements ElementMetaData {
    private transient AttributeMetaData[] attributesAsArray;
    private AttributeMap attributes;
    private HashMap styles;
    private Class elementType;
    private boolean container;
    private Class contentType;
    private transient StyleMetaData[] stylesArray;

    public DefaultElementMetaData(String name, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated, boolean container, AttributeMap attributes, HashMap styles, Class elementType, Class contentType, boolean experimental, int compatibilityLevel) {
        super(name, bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, experimental, compatibilityLevel);
        if (styles == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (elementType == null) {
            throw new NullPointerException();
        }
        if (contentType == null) {
            throw new NullPointerException();
        }
        this.contentType = contentType;
        this.container = container;
        this.attributes = (AttributeMap)attributes.clone();
        this.styles = (HashMap)styles.clone();
        this.elementType = elementType;
    }

    public AttributeMetaData[] getAttributeDescriptions() {
        if (this.attributesAsArray == null) {
            ArrayList<AttributeMetaData> buffer = new ArrayList<AttributeMetaData>();
            String[] namespaces = this.attributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                Map attrsNs = this.attributes.getAttributes(namespace);
                for (Map.Entry entry : attrsNs.entrySet()) {
                    AttributeMetaData exp = (AttributeMetaData)entry.getValue();
                    buffer.add(exp);
                }
            }
            this.attributesAsArray = buffer.toArray(new AttributeMetaData[buffer.size()]);
        }
        return (AttributeMetaData[])this.attributesAsArray.clone();
    }

    public StyleMetaData[] getStyleDescriptions() {
        if (this.stylesArray == null) {
            this.stylesArray = this.styles.values().toArray(new StyleMetaData[this.styles.size()]);
        }
        return this.stylesArray;
    }

    public AttributeMetaData getAttributeDescription(String namespace, String name) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        return (AttributeMetaData)this.attributes.getAttribute(namespace, name);
    }

    public StyleMetaData getStyleDescription(StyleKey name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (StyleMetaData)this.styles.get(name);
    }

    public ElementType create() throws InstantiationException {
        try {
            return (ElementType)this.elementType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unable to instantiate " + this.elementType + ": IllegalAccessException caught");
        }
    }

    public boolean isContainerElement() {
        return this.container;
    }

    public Class getContentType() {
        return this.contentType;
    }
}

