/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;

public class DefaultExpressionMetaData
extends AbstractMetaData
implements ExpressionMetaData {
    public static final int NO_LAYOUT_PROCESSOR = 0;
    public static final int ELEMENT_LAYOUT_PROCESSOR = 1;
    public static final int GLOBAL_LAYOUT_PROCESSOR = 2;
    private Class expressionType;
    private Class resultType;
    private HashMap properties;
    private BeanInfo beanInfo;
    private int layoutProcessorMode;
    private transient String[] propertyKeys;
    private transient ExpressionPropertyMetaData[] propertyMetaData;

    public DefaultExpressionMetaData(String bundleLocation, boolean expert, boolean preferred, boolean hidden, boolean deprecated, Class expressionType, Class resultType, HashMap attributes, BeanInfo beanInfo, int layoutProcessorMode, boolean experimental, int compatibilityLevel) {
        super(expressionType.getName(), bundleLocation, "", expert, preferred, hidden, deprecated, experimental, compatibilityLevel);
        if (resultType == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (beanInfo == null) {
            throw new NullPointerException();
        }
        this.expressionType = expressionType;
        this.layoutProcessorMode = layoutProcessorMode;
        this.resultType = resultType;
        this.properties = (HashMap)attributes.clone();
        this.beanInfo = beanInfo;
    }

    protected String computePrefix(String keyPrefix, String name) {
        return "";
    }

    public boolean isStatefull() {
        return Function.class.isAssignableFrom(this.getExpressionType());
    }

    public Class getResultType() {
        return this.resultType;
    }

    public Class getExpressionType() {
        return this.expressionType;
    }

    public ExpressionPropertyMetaData getPropertyDescription(String name) {
        return (ExpressionPropertyMetaData)this.properties.get(name);
    }

    public String[] getPropertyNames() {
        if (this.propertyKeys == null) {
            this.propertyKeys = this.properties.keySet().toArray(new String[this.properties.size()]);
        }
        return this.propertyKeys;
    }

    public ExpressionPropertyMetaData[] getPropertyDescriptions() {
        if (this.propertyMetaData == null) {
            this.propertyMetaData = this.properties.values().toArray(new ExpressionPropertyMetaData[this.properties.size()]);
        }
        return this.propertyMetaData;
    }

    public BeanInfo getBeanDescriptor() throws IntrospectionException {
        return this.beanInfo;
    }

    public boolean isElementLayoutProcessor() {
        return this.layoutProcessorMode == 1;
    }

    public boolean isGlobalLayoutProcessor() {
        return this.layoutProcessorMode == 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExpressionMetaData that = (DefaultExpressionMetaData)o;
        return this.expressionType.equals(that.expressionType);
    }

    public int hashCode() {
        return this.expressionType.hashCode();
    }
}

