/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.net.URL;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ElementMetaDataParser {
    public static final String GLOBAL_INCLUDES_PREFIX = "org.pentaho.reporting.engine.classic.core.metadata.global-includes.";
    private static final Log logger = LogFactory.getLog(ElementMetaDataParser.class);

    private ElementMetaDataParser() {
    }

    public static void initializeElementMetaData() throws ModuleInitializeException {
        String namespaceRegistryPrefix = "org.pentaho.reporting.engine.classic.core.metadata.namespaces.";
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.core.metadata.namespaces.");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String prefix = key.substring("org.pentaho.reporting.engine.classic.core.metadata.namespaces.".length());
            String namespaceUri = configuration.getConfigProperty(key);
            if (prefix.length() == 0 || namespaceUri == null || namespaceUri.length() == 0) continue;
            ElementTypeRegistry.getInstance().registerNamespacePrefix(namespaceUri, prefix);
        }
        URL metaDataSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/core/metadata/meta-elements.xml", ElementMetaDataParser.class);
        if (metaDataSource == null) {
            throw new ModuleInitializeException("Error: Could not find the core element meta-data description file");
        }
        try {
            ElementTypeRegistry.getInstance().registerFromXml(metaDataSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the element meta-data description file", e);
        }
        URL expressionMetaSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/core/function/meta-expressions.xml", ElementMetaDataParser.class);
        if (expressionMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the core expression meta-data description file");
        }
        try {
            ExpressionRegistry.getInstance().registerFromXml(expressionMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the expression meta-data description file", e);
        }
        URL dataFactoryMetaSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/core/metadata/meta-datafactory.xml", ElementMetaDataParser.class);
        if (dataFactoryMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the core dataFactory meta-data description file");
        }
        try {
            DataFactoryRegistry.getInstance().registerFromXml(dataFactoryMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the datafactory meta-data description file", e);
        }
        URL reportPreProcessorMetaSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/core/metadata/meta-report-preprocessors.xml", ElementMetaDataParser.class);
        if (reportPreProcessorMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the core report-preprocessor meta-data description file");
        }
        try {
            ReportPreProcessorRegistry.getInstance().registerFromXml(reportPreProcessorMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the report-preprocessor meta-data description file", e);
        }
    }

    public static void initializeOptionalReportPreProcessorMetaData(String source) throws ModuleInitializeException {
        URL reportPreProcessorMetaSource = ObjectUtilities.getResource((String)source, ElementMetaDataParser.class);
        if (reportPreProcessorMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the core report-preprocessor meta-data description file");
        }
        try {
            ReportPreProcessorRegistry.getInstance().registerFromXml(reportPreProcessorMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the report-preprocessor meta-data description file", e);
        }
    }

    public static void initializeOptionalExpressionsMetaData(String source) throws ModuleInitializeException {
        URL expressionMetaSource = ObjectUtilities.getResource((String)source, ElementMetaDataParser.class);
        if (expressionMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the expression meta-data description file");
        }
        try {
            ExpressionRegistry.getInstance().registerFromXml(expressionMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the expression meta-data description file", e);
        }
    }

    public static void initializeOptionalElementMetaData(String source) throws ModuleInitializeException {
        URL metaDataSource = ObjectUtilities.getResource((String)source, ElementMetaDataParser.class);
        if (metaDataSource == null) {
            throw new ModuleInitializeException("Error: Could not find the optional element meta-data description file");
        }
        try {
            ElementTypeRegistry.getInstance().registerFromXml(metaDataSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the element meta-data description file", e);
        }
    }

    public static void initializeOptionalDataFactoryMetaData(String source) throws ModuleInitializeException {
        URL expressionMetaSource = ObjectUtilities.getResource((String)source, ElementMetaDataParser.class);
        if (expressionMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the datafactory meta-data description file");
        }
        try {
            DataFactoryRegistry.getInstance().registerFromXml(expressionMetaSource);
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new ModuleInitializeException("Error: Could not parse the datafactory meta-data description file", e);
        }
    }
}

