/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ElementTypeCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public final class ElementTypeRegistry {
    private static final Log logger = LogFactory.getLog(ElementTypeRegistry.class);
    private HashMap namespaceMapping;
    private HashMap backend = new HashMap();
    private static ElementTypeRegistry instance;

    public static synchronized ElementTypeRegistry getInstance() {
        if (instance == null) {
            instance = new ElementTypeRegistry();
        }
        return instance;
    }

    private ElementTypeRegistry() {
        this.namespaceMapping = new HashMap();
    }

    public void registerFromXml(URL metaDataSource) throws IOException {
        if (metaDataSource == null) {
            throw new NullPointerException("Error: Could not find the element meta-data description file");
        }
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.registerDefaults();
        try {
            Resource resource = resourceManager.createDirectly((Object)metaDataSource, ElementTypeCollection.class);
            ElementTypeCollection typeCollection = (ElementTypeCollection)resource.getResource();
            ElementMetaData[] types = typeCollection.getElementTypes();
            for (int i = 0; i < types.length; ++i) {
                ElementMetaData metaData = types[i];
                ElementTypeRegistry.getInstance().registerElement(metaData);
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public void registerElement(ElementMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.backend.put(metaData.getName(), metaData);
    }

    public ElementMetaData[] getAllElementTypes() {
        return this.backend.values().toArray(new ElementMetaData[this.backend.size()]);
    }

    public boolean isElementTypeRegistered(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        return this.backend.containsKey(identifier);
    }

    public ElementMetaData getElementType(String identifier) throws MetaDataLookupException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        ElementMetaData retval = (ElementMetaData)this.backend.get(identifier);
        if (retval == null) {
            throw new MetaDataLookupException("There is no meta-data defined for type '" + identifier + '\'');
        }
        return retval;
    }

    public String getNamespacePrefix(String namespaceUri) {
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        return (String)this.namespaceMapping.get(namespaceUri);
    }

    public void registerNamespacePrefix(String namespaceUri, String namespacePrefix) {
        if (namespacePrefix == null) {
            throw new NullPointerException();
        }
        if (namespaceUri == null) {
            throw new NullPointerException();
        }
        this.namespaceMapping.put(namespaceUri, namespacePrefix);
    }
}

