/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionMetaDataCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ExpressionRegistry {
    private static final Log logger = LogFactory.getLog(ExpressionRegistry.class);
    private static ExpressionRegistry instance;
    private HashMap backend = new HashMap();

    public static synchronized ExpressionRegistry getInstance() {
        if (instance == null) {
            instance = new ExpressionRegistry();
        }
        return instance;
    }

    private ExpressionRegistry() {
    }

    public void registerFromXml(URL expressionMetaSource) throws IOException {
        if (expressionMetaSource == null) {
            throw new NullPointerException("Error: Could not find the expression meta-data description file");
        }
        try {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            Resource resource = resourceManager.createDirectly((Object)expressionMetaSource, ExpressionMetaDataCollection.class);
            ExpressionMetaDataCollection typeCollection = (ExpressionMetaDataCollection)resource.getResource();
            ExpressionMetaData[] types = typeCollection.getExpressionMetaData();
            for (int i = 0; i < types.length; ++i) {
                ExpressionMetaData metaData = types[i];
                if (metaData == null) continue;
                this.registerExpression(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public void registerExpression(ExpressionMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        Class type = metaData.getExpressionType();
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new IllegalArgumentException("Expression-Implementation cannot be abstract or an interface.");
        }
        this.backend.put(type.getName(), metaData);
    }

    public ExpressionMetaData[] getAllExpressionMetaDatas() {
        return this.backend.values().toArray(new ExpressionMetaData[this.backend.size()]);
    }

    public boolean isExpressionRegistered(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        return this.backend.containsKey(identifier);
    }

    public ExpressionMetaData getExpressionMetaData(String identifier) throws MetaDataLookupException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        ExpressionMetaData retval = (ExpressionMetaData)this.backend.get(identifier);
        if (retval == null) {
            throw new MetaDataLookupException("Unable to locate metadata for expression type " + identifier);
        }
        return retval;
    }
}

