/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ReportPreProcessorMetaDataCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ReportPreProcessorRegistry {
    private static final Log logger = LogFactory.getLog(ReportPreProcessorRegistry.class);
    private static ReportPreProcessorRegistry instance;
    private HashMap backend = new HashMap();

    public static synchronized ReportPreProcessorRegistry getInstance() {
        if (instance == null) {
            instance = new ReportPreProcessorRegistry();
        }
        return instance;
    }

    private ReportPreProcessorRegistry() {
    }

    public void registerFromXml(URL expressionMetaSource) throws IOException {
        if (expressionMetaSource == null) {
            throw new NullPointerException("Error: Could not find the report-preprocessor meta-data description file");
        }
        try {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            Resource resource = resourceManager.createDirectly((Object)expressionMetaSource, ReportPreProcessorMetaDataCollection.class);
            ReportPreProcessorMetaDataCollection typeCollection = (ReportPreProcessorMetaDataCollection)resource.getResource();
            ReportPreProcessorMetaData[] types = typeCollection.getReportPreProcessorMetaData();
            for (int i = 0; i < types.length; ++i) {
                ReportPreProcessorMetaData metaData = types[i];
                if (metaData == null) continue;
                ReportPreProcessorRegistry.getInstance().registerReportPreProcessor(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public void registerReportPreProcessor(ReportPreProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        Class type = metaData.getPreProcessorType();
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new IllegalArgumentException("report-preprocessor-Implementation cannot be abstract or an interface.");
        }
        this.backend.put(type.getName(), metaData);
    }

    public ReportPreProcessorMetaData[] getAllReportPreProcessorMetaDatas() {
        return this.backend.values().toArray(new ReportPreProcessorMetaData[this.backend.size()]);
    }

    public boolean isReportPreProcessorRegistered(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        return this.backend.containsKey(identifier);
    }

    public ReportPreProcessorMetaData getReportPreProcessorMetaData(String identifier) throws MetaDataLookupException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        ReportPreProcessorMetaData retval = (ReportPreProcessorMetaData)this.backend.get(identifier);
        if (retval == null) {
            throw new MetaDataLookupException("Unable to locate metadata for report-preprocessor type " + identifier);
        }
        return retval;
    }
}

