/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportProcessTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ReportProcessTaskRegistry {
    private HashMap exportTypes = new HashMap();
    private static ReportProcessTaskRegistry processTaskRegistry;

    public static synchronized ReportProcessTaskRegistry getInstance() {
        if (processTaskRegistry == null) {
            processTaskRegistry = new ReportProcessTaskRegistry();
        }
        return processTaskRegistry;
    }

    private ReportProcessTaskRegistry() {
    }

    public void registerExportType(String exportType, Class exportTask) {
        if (exportType == null) {
            throw new NullPointerException();
        }
        if (exportTask == null) {
            throw new NullPointerException();
        }
        if (!ReportProcessTask.class.isAssignableFrom(exportTask)) {
            throw new IllegalArgumentException("Invalid Implementation: " + exportTask);
        }
        this.exportTypes.put(exportType, exportTask.getName());
    }

    public String[] getExportTypes() {
        return this.exportTypes.keySet().toArray(new String[this.exportTypes.size()]);
    }

    public boolean isExportTypeRegistered(String exportType) {
        return this.exportTypes.containsKey(exportType);
    }

    public ReportProcessTask createProcessTask(String exportType) {
        String c = (String)this.exportTypes.get(exportType);
        ReportProcessTask o = (ReportProcessTask)ObjectUtilities.loadAndInstantiate((String)c, ReportProcessTaskRegistry.class, ReportProcessTask.class);
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return o;
    }
}

