/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.metadata.AttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeReadHandler
extends AbstractXmlReadHandler {
    private String namespace;
    private String name;
    private boolean preferred;
    private boolean mandatory;
    private boolean expert;
    private boolean hidden;
    private boolean computed;
    private boolean transientFlag;
    private Class valueType;
    private String valueRole;
    private boolean deprecated;
    private boolean bulk;
    private String propertyEditor;
    private boolean designTimeValue;
    private String bundle;
    private AttributeCore attributeCore;
    private boolean experimental;
    private int compatibilityLevel;

    public AttributeReadHandler(String bundle) {
        this.bundle = bundle;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String metaDataCoreClass;
        this.namespace = attrs.getValue(this.getUri(), "namespace");
        if (this.namespace == null) {
            throw new ParseException("Attribute 'namespace' is undefined", this.getLocator());
        }
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        this.mandatory = "true".equals(attrs.getValue(this.getUri(), "mandatory"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.computed = "true".equals(attrs.getValue(this.getUri(), "computed"));
        this.transientFlag = "true".equals(attrs.getValue(this.getUri(), "transient"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.bulk = "true".equals(attrs.getValue(this.getUri(), "prefer-bulk"));
        this.designTimeValue = "true".equals(attrs.getValue(this.getUri(), "design-time-value"));
        String valueTypeText = attrs.getValue(this.getUri(), "value-type");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'value-type' is undefined", this.getLocator());
        }
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
            this.valueType = Class.forName(valueTypeText, false, classLoader);
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'value-type' is not valid", e, this.getLocator());
        }
        this.valueRole = attrs.getValue(this.getUri(), "value-role");
        if (this.valueRole == null) {
            this.valueRole = "Value";
        }
        this.propertyEditor = attrs.getValue(this.getUri(), "propertyEditor");
        String bundleFromAttributes = attrs.getValue(this.getUri(), "bundle-name");
        if (bundleFromAttributes != null) {
            this.bundle = bundleFromAttributes;
        }
        if ((metaDataCoreClass = attrs.getValue(this.getUri(), "impl")) != null) {
            this.attributeCore = (AttributeCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, AttributeReadHandler.class, AttributeCore.class);
            if (this.attributeCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid AttributeCore implementation.", this.getLocator());
            }
        } else {
            this.attributeCore = new DefaultAttributeCore();
        }
    }

    public AttributeCore getAttributeCore() {
        return this.attributeCore;
    }

    public String getPropertyEditor() {
        return this.propertyEditor;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public String getValueRole() {
        return this.valueRole;
    }

    public Object getObject() throws SAXException {
        return new AttributeDefinition(this.namespace, this.name, this.preferred, this.mandatory, this.expert, this.hidden, this.computed, this.transientFlag, this.valueType, this.valueRole, this.propertyEditor, this.deprecated, this.bulk, this.designTimeValue, this.bundle, this.attributeCore, this.experimental, this.compatibilityLevel);
    }

    public String getBundle() {
        return this.bundle;
    }

    public boolean isDesignTimeValue() {
        return this.designTimeValue;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }
}

