/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.DataFactoryMetaDataCollection;
import org.pentaho.reporting.engine.classic.core.metadata.parser.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataFactoriesReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(DataFactoriesReadHandler.class);
    private ArrayList elements;
    private GlobalMetaDefinition globalMetaDefinition = new GlobalMetaDefinition();
    private DataFactoryMetaDataCollection typeCollection;

    public DataFactoriesReadHandler() {
        this.elements = new ArrayList();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        ResourceKey context = this.getRootHandler().getContext();
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.core.metadata.global-includes.");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String href = configuration.getConfigProperty(key);
            if (StringUtils.isEmpty((String)href, (boolean)true)) continue;
            try {
                ResourceKey resourceKey = resourceManager.deriveKey(context, href);
                Resource resource = resourceManager.create(resourceKey, null, GlobalMetaDefinition.class);
                this.globalMetaDefinition.merge((GlobalMetaDefinition)resource.getResource());
            }
            catch (ResourceException e) {
                logger.warn((Object)("Failed to parse included global definitions: " + this.getLocator()), (Throwable)e);
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("data-factory".equals(tagName)) {
            DataFactoryReadHandler readHandler = new DataFactoryReadHandler();
            this.elements.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        DataFactoryMetaData[] result = new DataFactoryMetaData[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            DataFactoryReadHandler handler = (DataFactoryReadHandler)((Object)this.elements.get(i));
            result[i] = (DataFactoryMetaData)handler.getObject();
        }
        this.typeCollection = new DataFactoryMetaDataCollection(result);
    }

    public Object getObject() throws SAXException {
        return this.typeCollection;
    }
}

