/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataFactoryReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private boolean experimental;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private boolean deprecated;
    private String bundleName;
    private boolean editable;
    private boolean freeformQuery;
    private boolean formattingMetadataSource;
    private DataFactoryCore dataFactoryCore;
    private int compatibilityLevel;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibilityLevel"));
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        String editable = attrs.getValue(this.getUri(), "editable");
        this.editable = editable == null || "true".equals(editable);
        this.freeformQuery = "true".equals(attrs.getValue(this.getUri(), "freeform-query"));
        this.formattingMetadataSource = "true".equals(attrs.getValue(this.getUri(), "metadata-source"));
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            this.dataFactoryCore = (DataFactoryCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, DataFactoryReadHandler.class, DataFactoryCore.class);
            if (this.dataFactoryCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid DataFactoryPropertyCore implementation.", this.getLocator());
            }
        } else {
            this.dataFactoryCore = new DefaultDataFactoryCore();
        }
    }

    protected void doneParsing() throws SAXException {
    }

    public Object getObject() throws SAXException {
        return new DefaultDataFactoryMetaData(this.name, this.bundleName, "datafactory.", this.expert, this.preferred, this.hidden, this.deprecated, this.editable, this.freeformQuery, this.formattingMetadataSource, this.experimental, this.dataFactoryCore, this.compatibilityLevel);
    }
}

