/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExpressionPropertyReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private boolean preferred;
    private boolean mandatory;
    private boolean expert;
    private boolean hidden;
    private String valueRole;
    private boolean deprecated;
    private BeanInfo expression;
    private String bundleLocation;
    private PropertyDescriptor descriptor;
    private String propertyEditorClass;
    private boolean computed;
    private ExpressionPropertyCore expressionPropertyCore;
    private boolean experimental;
    private int compatibilityLevel;

    public ExpressionPropertyReadHandler(BeanInfo expression, String bundleLocation) {
        this.expression = expression;
        this.bundleLocation = bundleLocation;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Attribute 'name' is undefined", this.getLocator());
        }
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        this.mandatory = "true".equals(attrs.getValue(this.getUri(), "mandatory"));
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.computed = "true".equals(attrs.getValue(this.getUri(), "computed"));
        this.valueRole = attrs.getValue(this.getUri(), "value-role");
        if (this.valueRole == null) {
            this.valueRole = "Value";
        }
        this.propertyEditorClass = attrs.getValue(this.getUri(), "propertyEditor");
        PropertyDescriptor[] descriptors = this.expression.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor maybeDescriptor = descriptors[i];
            if (!this.name.equals(maybeDescriptor.getName())) continue;
            this.descriptor = maybeDescriptor;
            break;
        }
        if (this.descriptor == null) {
            throw new ParseException("Attribute 'name' with value '" + this.name + "' does not reference a valid property. [" + this.expression.getBeanDescriptor().getBeanClass() + "]", this.getLocator());
        }
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            this.expressionPropertyCore = (ExpressionPropertyCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, ExpressionPropertyReadHandler.class, ExpressionPropertyCore.class);
            if (this.expressionPropertyCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid ExpressionPropertyCore implementation.", this.getLocator());
            }
        } else {
            this.expressionPropertyCore = new DefaultExpressionPropertyCore();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getValueRole() {
        return this.valueRole;
    }

    public Object getObject() throws SAXException {
        return new DefaultExpressionPropertyMetaData(this.name, this.bundleLocation, this.expert, this.preferred, this.hidden, this.deprecated, this.mandatory, this.computed, this.valueRole, this.descriptor, this.propertyEditorClass, this.expressionPropertyCore, this.experimental, this.compatibilityLevel);
    }
}

