/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleReadHandler;
import org.pentaho.reporting.libraries.base.util.LinkedMap;

public class GlobalMetaDefinition
implements Cloneable {
    private HashMap styleGroups = new HashMap();
    private HashMap attributeGroups = new HashMap();

    public void addAttributeGroup(AttributeGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.attributeGroups.put(group.getName(), group);
    }

    public void addStyleGroup(StyleGroup group) {
        if (group == null) {
            throw new NullPointerException();
        }
        this.styleGroups.put(group.getName(), group);
    }

    public StyleGroup getStyleGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (StyleGroup)this.styleGroups.get(name);
    }

    public AttributeGroup getAttributeGroup(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (AttributeGroup)this.attributeGroups.get(name);
    }

    public Object clone() throws CloneNotSupportedException {
        GlobalMetaDefinition definition = (GlobalMetaDefinition)super.clone();
        definition.styleGroups = (HashMap)this.styleGroups.clone();
        definition.attributeGroups = (HashMap)this.attributeGroups.clone();
        return definition;
    }

    public void merge(GlobalMetaDefinition definition) {
        if (definition == null) {
            throw new NullPointerException();
        }
        this.mergeStyles(definition);
        for (Map.Entry entry : definition.attributeGroups.entrySet()) {
            AttributeGroup styleGroup = (AttributeGroup)this.attributeGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addAttributeGroup((AttributeGroup)entry.getValue());
                continue;
            }
            AttributeGroup entryGroup = (AttributeGroup)entry.getValue();
            String name = styleGroup.getName();
            LinkedMap styles = new LinkedMap();
            AttributeDefinition[] data = styleGroup.getMetaData();
            for (int i = 0; i < data.length; ++i) {
                AttributeDefinition handler = data[i];
                styles.put((Object)handler.getName(), (Object)handler);
            }
            AttributeDefinition[] entryData = entryGroup.getMetaData();
            for (int i = 0; i < entryData.length; ++i) {
                AttributeDefinition handler = entryData[i];
                styles.put((Object)handler.getName(), (Object)handler);
            }
            this.addAttributeGroup(new AttributeGroup(name, (AttributeDefinition[])styles.values((Object[])new AttributeDefinition[styles.size()])));
        }
    }

    private void mergeStyles(GlobalMetaDefinition definition) {
        for (Map.Entry entry : definition.styleGroups.entrySet()) {
            StyleGroup styleGroup = (StyleGroup)this.styleGroups.get(entry.getKey());
            if (styleGroup == null) {
                this.addStyleGroup((StyleGroup)entry.getValue());
                continue;
            }
            StyleGroup entryGroup = (StyleGroup)entry.getValue();
            String name = styleGroup.getName();
            LinkedMap styles = new LinkedMap();
            StyleReadHandler[] data = styleGroup.getMetaData();
            for (int i = 0; i < data.length; ++i) {
                StyleReadHandler handler = data[i];
                styles.put((Object)handler.getName(), (Object)handler);
            }
            StyleReadHandler[] entryData = entryGroup.getMetaData();
            for (int i = 0; i < entryData.length; ++i) {
                StyleReadHandler handler = entryData[i];
                styles.put((Object)handler.getName(), (Object)handler);
            }
            this.addStyleGroup(new StyleGroup(name, (StyleReadHandler[])styles.values((Object[])new StyleReadHandler[styles.size()])));
        }
    }
}

