/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AttributeGroupReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ElementReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ElementTypeCollection;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.IncludeGlobalMetaDataReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroupReadHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetaDataReadHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(MetaDataReadHandler.class);
    private ArrayList elements;
    private GlobalMetaDefinition globalMetaDefinition = new GlobalMetaDefinition();
    private ElementTypeCollection typeCollection;

    public MetaDataReadHandler() {
        this.elements = new ArrayList();
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        ResourceKey context = this.getRootHandler().getContext();
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator keys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.core.metadata.global-includes.");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String href = configuration.getConfigProperty(key);
            if (StringUtils.isEmpty((String)href, (boolean)true)) continue;
            try {
                ResourceKey resourceKey = resourceManager.deriveKey(context, href);
                Resource resource = resourceManager.create(resourceKey, null, GlobalMetaDefinition.class);
                this.globalMetaDefinition.merge((GlobalMetaDefinition)resource.getResource());
            }
            catch (ResourceException e) {
                logger.warn((Object)("Failed to parse included global definitions: " + this.getLocator()), (Throwable)e);
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("attribute-group".equals(tagName)) {
            return new AttributeGroupReadHandler(this.globalMetaDefinition);
        }
        if ("style-group".equals(tagName)) {
            return new StyleGroupReadHandler(this.globalMetaDefinition);
        }
        if ("include-globals".equals(tagName)) {
            return new IncludeGlobalMetaDataReadHandler(this.globalMetaDefinition);
        }
        if ("element".equals(tagName)) {
            ElementReadHandler readHandler = new ElementReadHandler(this.globalMetaDefinition);
            this.elements.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        ElementMetaData[] result = new ElementMetaData[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementReadHandler handler = (ElementReadHandler)((Object)this.elements.get(i));
            result[i] = (ElementMetaData)handler.getObject();
        }
        this.typeCollection = new ElementTypeCollection(result);
    }

    public Object getObject() throws SAXException {
        return this.typeCollection;
    }
}

