/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.metadata.parser.ReportPreProcessorPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportPreProcessorReadHandler
extends AbstractXmlReadHandler {
    private String bundleName;
    private Class expressionClass;
    private String prefix;
    private boolean expert;
    private boolean hidden;
    private boolean preferred;
    private boolean deprecated;
    private ArrayList attributeHandlers = new ArrayList();
    private BeanInfo beanInfo;
    private HashMap properties = new HashMap();
    private boolean autoProcess;
    private boolean experimental;
    private int compatibilityLevel;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.bundleName = attrs.getValue(this.getUri(), "bundle-name");
        this.expert = "true".equals(attrs.getValue(this.getUri(), "expert"));
        this.hidden = "true".equals(attrs.getValue(this.getUri(), "hidden"));
        this.preferred = "true".equals(attrs.getValue(this.getUri(), "preferred"));
        this.deprecated = "true".equals(attrs.getValue(this.getUri(), "deprecated"));
        this.autoProcess = "true".equals(attrs.getValue(this.getUri(), "auto-process"));
        this.experimental = "true".equals(attrs.getValue(this.getUri(), "experimental"));
        this.compatibilityLevel = ReportParserUtil.parseVersion(attrs.getValue(this.getUri(), "compatibility-level"));
        String valueTypeText = attrs.getValue(this.getUri(), "class");
        if (valueTypeText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ExpressionReadHandler.class);
            this.expressionClass = Class.forName(valueTypeText, false, loader);
            if (!ReportPreProcessor.class.isAssignableFrom(this.expressionClass)) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
        try {
            this.beanInfo = Introspector.getBeanInfo(this.expressionClass);
        }
        catch (IntrospectionException e) {
            throw new ParseException("Cannot introspect specified " + this.expressionClass, this.getLocator());
        }
        this.prefix = "pre-processor." + this.expressionClass.getName();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            ReportPreProcessorPropertyReadHandler readHandler = new ReportPreProcessorPropertyReadHandler(this.beanInfo, this.bundleName, this.prefix + ".property.");
            this.attributeHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.attributeHandlers.size(); ++i) {
            ReportPreProcessorPropertyReadHandler handler = (ReportPreProcessorPropertyReadHandler)((Object)this.attributeHandlers.get(i));
            String attrName = handler.getName();
            this.properties.put(attrName, handler.getObject());
        }
    }

    public Object getObject() throws SAXException {
        return new DefaultReportPreProcessorMetaData(this.bundleName, "pre-processor.", this.expert, this.preferred, this.hidden, this.deprecated, this.expressionClass, this.properties, this.beanInfo, this.autoProcess, this.experimental, this.compatibilityLevel);
    }
}

