/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultStyleKeyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.parser.GlobalMetaDefinition;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleGroup;
import org.pentaho.reporting.engine.classic.core.metadata.parser.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StyleGroupRefReadHandler
extends AbstractXmlReadHandler {
    private HashMap styles;
    private GlobalMetaDefinition styleGroups;
    private String bundle;

    public StyleGroupRefReadHandler(HashMap styles, GlobalMetaDefinition styleGroups, String bundle) {
        this.styles = styles;
        this.styleGroups = styleGroups;
        this.bundle = bundle;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String name = attrs.getValue(this.getUri(), "ref");
        if (name == null) {
            throw new ParseException("Attribute 'ref' is undefined", this.getLocator());
        }
        StyleGroup group = this.styleGroups.getStyleGroup(name);
        if (group == null) {
            throw new ParseException("Attribute 'ref' is invalid. There is no style-group '" + name + "' defined.", this.getLocator());
        }
        StyleReadHandler[] data = group.getMetaData();
        for (int i = 0; i < data.length; ++i) {
            StyleReadHandler handler = data[i];
            String keyName = handler.getName();
            StyleKey key = StyleKey.getStyleKey(keyName);
            if (key == null) {
                throw new ParseException("There is no such key '" + keyName + "' defined.");
            }
            String bundle = handler.getBundleName() != null ? handler.getBundleName() : this.bundle;
            DefaultStyleKeyMetaData metaData = new DefaultStyleKeyMetaData(key, handler.getPropertyEditor(), bundle, "style.", handler.isExpert(), handler.isPreferred(), handler.isHidden(), handler.isDeprecated(), handler.isExperimental(), handler.getCompatibilityLevel());
            this.styles.put(key, metaData);
        }
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

