/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AggregationTypePropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Class value;
    private String[] availableTypeNames;
    private Class[] availableTypes;

    public AggregationTypePropertyEditor() {
        ExpressionMetaData[] allExpressionMetaDatas = ExpressionRegistry.getInstance().getAllExpressionMetaDatas();
        ArrayList<ExpressionMetaData> list = new ArrayList<ExpressionMetaData>();
        list.add(null);
        for (int i = 0; i < allExpressionMetaDatas.length; ++i) {
            ExpressionMetaData data = allExpressionMetaDatas[i];
            if (data.isHidden() || !AggregationFunction.class.isAssignableFrom(data.getExpressionType())) continue;
            list.add(data);
        }
        Locale locale = Locale.getDefault();
        this.availableTypeNames = new String[list.size()];
        this.availableTypes = new Class[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ExpressionMetaData data = (ExpressionMetaData)list.get(i);
            if (data == null) {
                this.availableTypeNames[i] = null;
                this.availableTypes[i] = null;
                continue;
            }
            this.availableTypeNames[i] = data.getDisplayName(locale);
            this.availableTypes[i] = data.getExpressionType();
        }
    }

    public void setValue(Object value) {
        Class oldValue = this.value;
        this.value = !(value instanceof Class) ? null : (Class)value;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        for (int i = 0; i < this.availableTypes.length; ++i) {
            if (!ObjectUtilities.equal((Object)this.availableTypes[i], (Object)this.value)) continue;
            return this.availableTypeNames[i];
        }
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        for (int i = 0; i < this.availableTypeNames.length; ++i) {
            if (!ObjectUtilities.equal((Object)this.availableTypeNames[i], (Object)text)) continue;
            this.setValue(this.availableTypes[i]);
            return;
        }
        this.setValue(null);
    }

    public String[] getTags() {
        return (String[])this.availableTypeNames.clone();
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

