/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BorderStyleValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class BorderStylePropertyEditor
implements PropertyEditor {
    private BorderStyleValueConverter valueConverter;
    private BorderStyle value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public BorderStylePropertyEditor() {
        this.valueConverter = new BorderStyleValueConverter();
    }

    public void setValue(Object value) {
        BorderStyle oldValue = this.value;
        this.value = value instanceof BorderStyle ? (BorderStyle)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (BorderStyle.DASHED.equals(this.value)) {
            return BorderStyle.class.getName() + ".DASHED";
        }
        if (BorderStyle.DOT_DASH.equals(this.value)) {
            return BorderStyle.class.getName() + ".DOT_DASH";
        }
        if (BorderStyle.DOT_DOT_DASH.equals(this.value)) {
            return BorderStyle.class.getName() + ".DOT_DOT_DASH";
        }
        if (BorderStyle.DOTTED.equals(this.value)) {
            return BorderStyle.class.getName() + ".DOTTED";
        }
        if (BorderStyle.DOUBLE.equals(this.value)) {
            return BorderStyle.class.getName() + ".DOUBLE";
        }
        if (BorderStyle.GROOVE.equals(this.value)) {
            return BorderStyle.class.getName() + ".GROOVE";
        }
        if (BorderStyle.HIDDEN.equals(this.value)) {
            return BorderStyle.class.getName() + ".HIDDEN";
        }
        if (BorderStyle.INSET.equals(this.value)) {
            return BorderStyle.class.getName() + ".INSET";
        }
        if (BorderStyle.NONE.equals(this.value)) {
            return BorderStyle.class.getName() + ".NONE";
        }
        if (BorderStyle.OUTSET.equals(this.value)) {
            return BorderStyle.class.getName() + ".OUTSET";
        }
        if (BorderStyle.RIDGE.equals(this.value)) {
            return BorderStyle.class.getName() + ".RIDGE";
        }
        if (BorderStyle.SOLID.equals(this.value)) {
            return BorderStyle.class.getName() + ".SOLID";
        }
        if (BorderStyle.WAVE.equals(this.value)) {
            return BorderStyle.class.getName() + ".WAVE";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{null, BorderStyle.SOLID.toString(), BorderStyle.DASHED.toString(), BorderStyle.DOT_DASH.toString(), BorderStyle.DOT_DOT_DASH.toString(), BorderStyle.DOTTED.toString(), BorderStyle.DOUBLE.toString(), BorderStyle.HIDDEN.toString(), BorderStyle.NONE.toString(), BorderStyle.GROOVE.toString(), BorderStyle.RIDGE.toString(), BorderStyle.INSET.toString(), BorderStyle.OUTSET.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

