/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BoxSizingValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class BoxSizingPropertyEditor
implements PropertyEditor {
    private BoxSizingValueConverter valueConverter;
    private BoxSizing value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public BoxSizingPropertyEditor() {
        this.valueConverter = new BoxSizingValueConverter();
    }

    public void setValue(Object value) {
        BoxSizing oldValue = this.value;
        this.value = BoxSizing.BORDER_BOX.equals(value) ? BoxSizing.BORDER_BOX : (BoxSizing.CONTENT_BOX.equals(value) ? BoxSizing.CONTENT_BOX : null);
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (BoxSizing.BORDER_BOX.equals(this.value)) {
            return BoxSizing.class.getName() + ".BORDER_BOX";
        }
        if (BoxSizing.CONTENT_BOX.equals(this.value)) {
            return BoxSizing.class.getName() + ".CONTENT_BOX";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{BoxSizing.BORDER_BOX.toString(), BoxSizing.CONTENT_BOX.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

