/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;

public class CompatibilityLevelPropertyEditor
implements PropertyEditor {
    private String[] TAGS = new String[]{null, "3.8.3", "3.9.0"};
    private int[] TAG_MAP = new int[]{-1, 3008003, 3009000};
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Integer value;

    public void setValue(Object value) {
        if (value == null || value instanceof Integer) {
            Integer oldValue = this.value;
            this.value = (Integer)value;
            this.propertyChangeSupport.firePropertyChange((String)null, oldValue, this.value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        int ix = this.value;
        for (int i = 0; i < this.TAG_MAP.length; ++i) {
            if (this.TAG_MAP[i] != ix) continue;
            return this.TAGS[i];
        }
        if (ix < 0) {
            return null;
        }
        int patch = this.value % 1000;
        int minor = (this.value - patch) % 1000000;
        int major = this.value - minor - patch;
        return major / 1000000 + "." + minor / 1000 + "." + patch;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        int i;
        if (text == null) {
            this.setValue(null);
            return;
        }
        for (i = 0; i < this.TAGS.length; ++i) {
            if (!text.equals(this.TAGS[i])) continue;
            this.setValue(this.TAG_MAP[i]);
            return;
        }
        i = ClassicEngineBoot.parseVersionId(text);
        if (i != -1) {
            this.setValue(i);
        } else {
            this.setValue(null);
        }
    }

    public String[] getTags() {
        String asText = this.getAsText();
        if (asText == null) {
            return (String[])this.TAGS.clone();
        }
        TreeSet<String> tags = new TreeSet<String>();
        for (String s : this.TAGS) {
            if (s == null) continue;
            tags.add(s);
        }
        tags.add(asText);
        String[] retval = new String[tags.size() + 1];
        System.arraycopy(tags.toArray(new String[tags.size()]), 0, retval, 1, tags.size());
        return retval;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getJavaInitializationString() {
        return String.valueOf(this.value);
    }
}

