/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.FontSmoothValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class FontSmoothPropertyEditor
implements PropertyEditor {
    private FontSmoothValueConverter valueConverter;
    private FontSmooth value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public FontSmoothPropertyEditor() {
        this.valueConverter = new FontSmoothValueConverter();
    }

    public void setValue(Object value) {
        FontSmooth oldValue = this.value;
        this.value = FontSmooth.AUTO.equals(value) ? FontSmooth.AUTO : (FontSmooth.ALWAYS.equals(value) ? FontSmooth.ALWAYS : (FontSmooth.NEVER.equals(value) ? FontSmooth.NEVER : null));
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (FontSmooth.ALWAYS.equals(this.value)) {
            return FontSmooth.class.getName() + ".ALWAYS";
        }
        if (FontSmooth.AUTO.equals(this.value)) {
            return FontSmooth.class.getName() + ".AUTO";
        }
        if (FontSmooth.NEVER.equals(this.value)) {
            return FontSmooth.class.getName() + ".NEVER";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{FontSmooth.AUTO.toString(), FontSmooth.ALWAYS.toString(), FontSmooth.NEVER.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

