/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class LengthPropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Float value;

    public void setValue(Object value) {
        Float oldValue = this.value;
        this.value = !(value instanceof Float) ? null : (Float)value;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        if (this.value.longValue() == Long.MAX_VALUE || this.value.longValue() == Long.MIN_VALUE) {
            return "auto";
        }
        if (this.value.floatValue() < 0.0f) {
            return -this.value.floatValue() + "%";
        }
        return this.value.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(LengthPropertyEditor.parseRelativeFloat(text));
    }

    public static Float parseRelativeFloat(String value) {
        if (value == null) {
            return null;
        }
        if ("auto".equalsIgnoreCase(value)) {
            return new Float(-9.223372E18f);
        }
        try {
            String tvalue = value.trim();
            if (tvalue.length() > 0 && tvalue.charAt(tvalue.length() - 1) == '%') {
                String number = tvalue.substring(0, tvalue.length() - 1);
                float f = Float.parseFloat(number.trim());
                return new Float(-f);
            }
            float f = Float.parseFloat(tvalue);
            return new Float(f);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

