/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.TextWrapValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class TextWrapPropertyEditor
implements PropertyEditor {
    private TextWrapValueConverter valueConverter;
    private TextWrap value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TextWrapPropertyEditor() {
        this.valueConverter = new TextWrapValueConverter();
    }

    public void setValue(Object value) {
        TextWrap oldValue = this.value;
        this.value = TextWrap.NONE.equals(value) ? TextWrap.NONE : (TextWrap.WRAP.equals(value) ? TextWrap.WRAP : null);
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (TextWrap.WRAP.equals(this.value)) {
            return TextWrap.class.getName() + ".WRAP";
        }
        if (TextWrap.NONE.equals(this.value)) {
            return TextWrap.class.getName() + ".NONE";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{TextWrap.NONE.toString(), TextWrap.WRAP.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

