/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.TimeZoneValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class TimeZonePropertyEditor
implements PropertyEditor {
    private TimeZoneValueConverter valueConverter;
    private TimeZone value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TimeZonePropertyEditor() {
        this.valueConverter = new TimeZoneValueConverter();
    }

    public void setValue(Object value) {
        TimeZone oldValue = this.value;
        this.value = value instanceof TimeZone ? (TimeZone)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (this.value != null) {
            return TimeZone.class.getName() + ".getTimeZone(\"" + this.value.getID() + "\")";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return TimeZone.getAvailableIDs();
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

