/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;

public class VerticalAlignmentPropertyEditor
implements PropertyEditor {
    private ElementAlignment value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setValue(Object value) {
        ElementAlignment oldValue = this.value;
        this.value = ElementAlignment.TOP.equals(value) ? ElementAlignment.TOP : (ElementAlignment.MIDDLE.equals(value) ? ElementAlignment.MIDDLE : (ElementAlignment.BOTTOM.equals(value) ? ElementAlignment.BOTTOM : null));
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (ElementAlignment.TOP.equals(this.value)) {
            return ElementAlignment.class.getName() + ".TOP";
        }
        if (ElementAlignment.MIDDLE.equals(this.value)) {
            return ElementAlignment.class.getName() + ".MIDDLE";
        }
        if (ElementAlignment.BOTTOM.equals(this.value)) {
            return ElementAlignment.class.getName() + ".BOTTOM";
        }
        return "null";
    }

    public String getAsText() {
        if (ElementAlignment.TOP.equals(this.value)) {
            return "TOP";
        }
        if (ElementAlignment.MIDDLE.equals(this.value)) {
            return "MIDDLE";
        }
        if (ElementAlignment.BOTTOM.equals(this.value)) {
            return "BOTTOM";
        }
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (ElementAlignment.TOP.toString().equals(text)) {
            this.setValue(ElementAlignment.TOP);
        } else if (ElementAlignment.MIDDLE.toString().equals(text)) {
            this.setValue(ElementAlignment.MIDDLE);
        } else if (ElementAlignment.BOTTOM.toString().equals(text)) {
            this.setValue(ElementAlignment.BOTTOM);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String[] getTags() {
        return new String[]{"TOP", "MIDDLE", "BOTTOM"};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

