/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.VerticalTextAlignValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class VerticalTextAlignmentPropertyEditor
implements PropertyEditor {
    private VerticalTextAlignValueConverter valueConverter;
    private VerticalTextAlign value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public VerticalTextAlignmentPropertyEditor() {
        this.valueConverter = new VerticalTextAlignValueConverter();
    }

    public void setValue(Object value) {
        VerticalTextAlign oldValue = this.value;
        this.value = VerticalTextAlign.TOP.equals(value) ? VerticalTextAlign.TOP : (VerticalTextAlign.TEXT_TOP.equals(value) ? VerticalTextAlign.TEXT_TOP : (VerticalTextAlign.BASELINE.equals(value) ? VerticalTextAlign.BASELINE : (VerticalTextAlign.BOTTOM.equals(value) ? VerticalTextAlign.BOTTOM : (VerticalTextAlign.CENTRAL.equals(value) ? VerticalTextAlign.CENTRAL : (VerticalTextAlign.MIDDLE.equals(value) ? VerticalTextAlign.MIDDLE : (VerticalTextAlign.SUB.equals(value) ? VerticalTextAlign.SUB : (VerticalTextAlign.SUPER.equals(value) ? VerticalTextAlign.SUPER : (VerticalTextAlign.TEXT_BOTTOM.equals(value) ? VerticalTextAlign.TEXT_BOTTOM : (VerticalTextAlign.USE_SCRIPT.equals(value) ? VerticalTextAlign.USE_SCRIPT : null)))))))));
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (VerticalTextAlign.TOP.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".TOP";
        }
        if (VerticalTextAlign.TEXT_TOP.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".TEXT_TOP";
        }
        if (VerticalTextAlign.BASELINE.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".BASELINE";
        }
        if (VerticalTextAlign.BOTTOM.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".BOTTOM";
        }
        if (VerticalTextAlign.CENTRAL.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".CENTRAL";
        }
        if (VerticalTextAlign.MIDDLE.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".MIDDLE";
        }
        if (VerticalTextAlign.SUB.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".SUB";
        }
        if (VerticalTextAlign.SUPER.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".SUPER";
        }
        if (VerticalTextAlign.TEXT_BOTTOM.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".TEXT_BOTTOM";
        }
        if (VerticalTextAlign.USE_SCRIPT.equals(this.value)) {
            return VerticalTextAlign.class.getName() + ".USE_SCRIPT";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{VerticalTextAlign.TOP.toString(), VerticalTextAlign.TEXT_TOP.toString(), VerticalTextAlign.SUPER.toString(), VerticalTextAlign.MIDDLE.toString(), VerticalTextAlign.CENTRAL.toString(), VerticalTextAlign.BASELINE.toString(), VerticalTextAlign.USE_SCRIPT.toString(), VerticalTextAlign.SUB.toString(), VerticalTextAlign.TEXT_BOTTOM.toString(), VerticalTextAlign.BOTTOM.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

