/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.WhitespaceCollapseValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class WhitespaceCollapsePropertyEditor
implements PropertyEditor {
    private WhitespaceCollapseValueConverter valueConverter;
    private WhitespaceCollapse value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public WhitespaceCollapsePropertyEditor() {
        this.valueConverter = new WhitespaceCollapseValueConverter();
    }

    public void setValue(Object value) {
        WhitespaceCollapse oldValue = this.value;
        this.value = WhitespaceCollapse.COLLAPSE.equals(value) ? WhitespaceCollapse.COLLAPSE : (WhitespaceCollapse.DISCARD.equals(value) ? WhitespaceCollapse.DISCARD : (WhitespaceCollapse.PRESERVE.equals(value) ? WhitespaceCollapse.PRESERVE : (WhitespaceCollapse.PRESERVE_BREAKS.equals(value) ? WhitespaceCollapse.PRESERVE_BREAKS : null)));
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        if (WhitespaceCollapse.COLLAPSE.equals(this.value)) {
            return WhitespaceCollapse.class.getName() + ".COLLAPSE";
        }
        if (WhitespaceCollapse.DISCARD.equals(this.value)) {
            return WhitespaceCollapse.class.getName() + ".DISCARD";
        }
        if (WhitespaceCollapse.PRESERVE.equals(this.value)) {
            return WhitespaceCollapse.class.getName() + ".PRESERVE";
        }
        if (WhitespaceCollapse.PRESERVE_BREAKS.equals(this.value)) {
            return WhitespaceCollapse.class.getName() + ".PRESERVE_BREAKS";
        }
        return "null";
    }

    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    public String[] getTags() {
        return new String[]{WhitespaceCollapse.PRESERVE.toString(), WhitespaceCollapse.PRESERVE_BREAKS.toString(), WhitespaceCollapse.COLLAPSE.toString(), WhitespaceCollapse.DISCARD.toString()};
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

