/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ParameterReportControllerPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.GuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.DefaultGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.FormValidator;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.ActionButton;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStorage;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStoreException;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractExportDialog
extends JDialog
implements ExportDialog {
    private static final Log logger = LogFactory.getLog(AbstractExportDialog.class);
    private Action cancelAction;
    private Action confirmAction;
    private FormValidator formValidator;
    private ResourceBundle resources;
    private boolean confirmed;
    private MasterReport reportJob;
    private GuiContext guiContext;
    private GuiContext defaultContext;
    private Messages messages;
    private JPanel parametersLayoutPanel;
    private ParameterReportControllerPane parametersPanel;

    protected AbstractExportDialog() {
        this.initialize();
    }

    protected AbstractExportDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    protected AbstractExportDialog(Dialog owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.guiContext = this.defaultContext = new DefaultGuiContext(this, null);
        ResourceBundle resources = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages");
        this.cancelAction = new CancelAction(resources);
        this.confirmAction = new ConfirmAction(resources);
        this.formValidator = new ExportDialogValidator();
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloseHandler());
        this.messages = new Messages(this.defaultContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
        this.parametersPanel = new ParameterReportControllerPane();
        this.parametersLayoutPanel = new JPanel(new BorderLayout());
        this.parametersLayoutPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.parametersLayoutPanel.add((Component)this.parametersPanel, "North");
    }

    protected JPanel createContentPane(JComponent realContent) {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createButtonPanel(), "South");
        contentPane.add((Component)realContent, "Center");
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        return contentWithStatus;
    }

    protected JPanel createButtonPanel() {
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add(btnConfirm);
        buttonPanel.add(btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(2));
        buttonCarrier.add(buttonPanel);
        return buttonCarrier;
    }

    public abstract JStatusBar getStatusBar();

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected void setCancelAction(Action cancelAction) {
        this.cancelAction = cancelAction;
    }

    protected Action getConfirmAction() {
        return this.confirmAction;
    }

    protected void setConfirmAction(Action confirmAction) {
        this.confirmAction = confirmAction;
    }

    protected abstract boolean performValidate();

    protected FormValidator getFormValidator() {
        return this.formValidator;
    }

    protected void initializeFromJob(MasterReport job, GuiContext guiContext) {
        JStatusBar statusBar = this.getStatusBar();
        if (statusBar != null) {
            statusBar.setIconTheme(guiContext.getIconTheme());
        }
    }

    protected MasterReport getReportJob() {
        return this.reportJob;
    }

    protected GuiContext getGuiContext() {
        return this.guiContext;
    }

    public boolean performQueryForExport(MasterReport reportJob, SwingGuiContext guiContext) {
        if (reportJob == null) {
            throw new NullPointerException();
        }
        if (guiContext == null) {
            throw new NullPointerException();
        }
        this.reportJob = reportJob;
        this.guiContext = guiContext;
        Locale locale = guiContext.getLocale();
        this.setLocale(locale);
        this.pack();
        this.clear();
        this.initializeFromJob(reportJob, guiContext);
        this.createParametersPanelContent();
        FormValidator formValidator = this.getFormValidator();
        formValidator.setEnabled(false);
        ModifiableConfiguration repConf = reportJob.getReportConfiguration();
        boolean inputStorageEnabled = this.isInputStorageEnabled((Configuration)repConf);
        Object loadedConfiguration = inputStorageEnabled ? this.loadFromConfigStore(reportJob, (Configuration)repConf) : repConf;
        this.setDialogContents((Configuration)loadedConfiguration);
        formValidator.setEnabled(true);
        formValidator.handleValidate();
        this.setModal(true);
        SwingUtil.centerDialogInParent(this);
        this.setVisible(true);
        if (!this.isConfirmed()) {
            this.guiContext = this.defaultContext;
            return false;
        }
        formValidator.setEnabled(false);
        Configuration fullDialogContents = this.grabDialogContents(true);
        Enumeration configProperties = fullDialogContents.getConfigProperties();
        while (configProperties.hasMoreElements()) {
            String key = (String)configProperties.nextElement();
            repConf.setConfigProperty(key, fullDialogContents.getConfigProperty(key));
        }
        if (inputStorageEnabled) {
            this.saveToConfigStore(reportJob, (Configuration)repConf);
        }
        formValidator.setEnabled(true);
        this.reportJob = null;
        this.guiContext = this.defaultContext;
        return true;
    }

    private void createParametersPanelContent() {
        ReportParameterDefinition theParamterDefinition = this.reportJob.getParameterDefinition();
        if (theParamterDefinition.getParameterCount() > 0) {
            try {
                this.parametersPanel.hideControls();
                this.parametersPanel.setReport(this.reportJob);
            }
            catch (ReportProcessingException e) {
                this.parametersPanel.setErrorMessage(this.messages.getString("AbstractExportDialog.ERROR_PARAMETERS"));
            }
        } else {
            this.parametersPanel.setErrorMessage(this.messages.getString("AbstractExportDialog.NO_PARAMETERS"));
        }
    }

    private void saveToConfigStore(MasterReport reportJob, Configuration reportConfiguration) {
        String configPath = ConfigFactory.encodePath(reportJob.getTitle() + this.getConfigurationSuffix());
        try {
            boolean fullStorageEnabled = this.isFullInputStorageEnabled(reportConfiguration);
            Configuration dialogContents = this.grabDialogContents(fullStorageEnabled);
            ConfigStorage storage = ConfigFactory.getInstance().getUserStorage();
            storage.store(configPath, dialogContents);
        }
        catch (ConfigStoreException cse) {
            logger.debug((Object)this.messages.getString("AbstractExportDialog.DEBUG_CANT_STORE_DEFAULTS", String.valueOf(this.getClass())));
        }
    }

    private Configuration loadFromConfigStore(MasterReport reportJob, Configuration defaultConfig) {
        String configPath = ConfigFactory.encodePath(reportJob.getTitle() + this.getConfigurationSuffix());
        ConfigStorage storage = ConfigFactory.getInstance().getUserStorage();
        try {
            return storage.load(configPath, defaultConfig);
        }
        catch (Exception cse) {
            logger.debug((Object)this.messages.getString("AbstractExportDialog.DEBUG_CANT_LOAD_DEFAULTS", String.valueOf(this.getClass())));
            return defaultConfig;
        }
    }

    protected abstract String getConfigurationPrefix();

    protected abstract Configuration grabDialogContents(boolean var1);

    protected abstract void setDialogContents(Configuration var1);

    protected abstract String getConfigurationSuffix();

    protected ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle(this.getResourceBaseName());
        }
        return this.resources;
    }

    protected boolean isInputStorageEnabled(Configuration config) {
        if (!"true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.StoreExportDialogInputs"))) {
            return false;
        }
        String confVal = config.getConfigProperty(this.getConfigurationPrefix() + "StoreDialogContents");
        return !"none".equalsIgnoreCase(confVal);
    }

    protected boolean isFullInputStorageEnabled(Configuration config) {
        if (!"true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.StoreExportDialogInputs"))) {
            return false;
        }
        String confVal = config.getConfigProperty(this.getConfigurationPrefix() + "StoreDialogContents");
        return "all".equalsIgnoreCase(confVal);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    protected void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected boolean performConfirm() {
        return true;
    }

    public abstract void clear();

    protected abstract String getResourceBaseName();

    protected File resolvePath(String baseDirectory) {
        if (baseDirectory == null) {
            throw new IllegalArgumentException(this.messages.getString("AbstractExportDialog.ERROR_0001_INVALID_BASE_DIR"));
        }
        if (!baseDirectory.startsWith("~/")) {
            return new File(baseDirectory);
        }
        String homeDirectory = System.getProperty("user.home");
        if ("~/".equals(baseDirectory)) {
            return new File(homeDirectory);
        }
        baseDirectory = baseDirectory.substring(2);
        return new File(homeDirectory, baseDirectory);
    }

    protected JPanel getParametersPanel() {
        return this.parametersLayoutPanel;
    }

    private class WindowCloseHandler
    extends WindowAdapter {
        protected WindowCloseHandler() {
        }

        public void windowClosing(WindowEvent e) {
            Action cancelAction = AbstractExportDialog.this.getCancelAction();
            if (cancelAction != null) {
                cancelAction.actionPerformed(null);
            } else {
                AbstractExportDialog.this.setConfirmed(false);
                AbstractExportDialog.this.setVisible(false);
            }
        }
    }

    private class ExportDialogValidator
    extends FormValidator {
        protected ExportDialogValidator() {
        }

        public boolean performValidate() {
            return AbstractExportDialog.this.performValidate();
        }

        public Action getConfirmAction() {
            return AbstractExportDialog.this.getConfirmAction();
        }
    }

    private class CancelAction
    extends AbstractAction {
        protected CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.cancelButtonText"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractExportDialog.this.setConfirmed(false);
            AbstractExportDialog.this.setVisible(false);
        }
    }

    private class ConfirmAction
    extends AbstractAction {
        protected ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.okButtonText"));
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractExportDialog.this.performValidate() && AbstractExportDialog.this.performConfirm()) {
                this.applyReportParameters();
                AbstractExportDialog.this.setConfirmed(true);
                AbstractExportDialog.this.setVisible(false);
            }
        }

        private void applyReportParameters() {
            ReportParameterDefinition theParamterDefinition = AbstractExportDialog.this.reportJob.getParameterDefinition();
            if (theParamterDefinition.getParameterCount() > 0) {
                ReportParameterValues properties = AbstractExportDialog.this.parametersPanel.getReportParameterValues();
                ReportParameterValues reportParameters = AbstractExportDialog.this.reportJob.getParameterValues();
                String[] strings = properties.getColumnNames();
                for (int i = 0; i < strings.length; ++i) {
                    String propertyName = strings[i];
                    reportParameters.put(propertyName, properties.get(propertyName));
                }
            }
        }
    }
}

