/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.RequestFocusHandler;

public class PreviewApplet
extends JApplet {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private JLabel pageLabel;

    public void init() {
        this.addComponentListener(new RequestFocusHandler());
        this.previewPane = new PreviewPane();
        this.previewPane.setDeferredRepagination(true);
        this.addComponentListener(new TriggerPaginationListener(this.previewPane));
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.progressBar = new ReportProgressBar();
        this.progressBar.setVisible(false);
        this.previewPane.addReportProgressListener(this.progressBar);
        this.pageLabel = new JLabel();
        this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        extensionArea.add(this.progressBar);
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
        this.updateMenu(this.previewPane.getMenu());
        this.statusBar.setIconTheme(this.previewPane.getIconTheme());
        this.statusBar.setStatus(this.previewPane.getStatusType(), this.previewPane.getStatusText());
    }

    private void updateMenu(JMenu[] menus) {
        if (menus != null && menus.length > 0) {
            JMenuBar menuBar = new JMenuBar();
            for (int i = 0; i < menus.length; ++i) {
                JMenu menu = menus[i];
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
        } else {
            this.setJMenuBar(null);
        }
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public MasterReport getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(MasterReport reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public boolean isToolbarFloatable() {
        return this.previewPane.isToolbarFloatable();
    }

    public void setToolbarFloatable(boolean toolbarFloatable) {
        this.previewPane.setToolbarFloatable(toolbarFloatable);
    }

    public double getZoom() {
        return this.previewPane.getZoom();
    }

    public void setZoom(double zoom) {
        this.previewPane.setZoom(zoom);
    }

    private static class TriggerPaginationListener
    extends ComponentAdapter {
        private PreviewPane pane;

        private TriggerPaginationListener(PreviewPane pane) {
            this.pane = pane;
        }

        public void componentShown(ComponentEvent e) {
            if (this.pane.isDeferredRepagination()) {
                this.pane.startPagination();
            }
        }
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        protected PreviewPanePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = PreviewApplet.this.previewPane.getMenu();
                if (menus != null && menus.length > 0) {
                    JMenuBar menuBar = new JMenuBar();
                    for (int i = 0; i < menus.length; ++i) {
                        JMenu menu = menus[i];
                        menuBar.add(menu);
                    }
                    PreviewApplet.this.setJMenuBar(menuBar);
                } else {
                    PreviewApplet.this.setJMenuBar(null);
                }
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                PreviewApplet.this.statusBar.setStatus(PreviewApplet.this.previewPane.getStatusType(), PreviewApplet.this.previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                PreviewApplet.this.statusBar.setIconTheme(PreviewApplet.this.previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewApplet.this.progressBar.setOnlyPagination(true);
                    PreviewApplet.this.progressBar.setVisible(true);
                    PreviewApplet.this.pageLabel.setVisible(false);
                } else {
                    PreviewApplet.this.progressBar.setOnlyPagination(false);
                    PreviewApplet.this.progressBar.setVisible(false);
                    PreviewApplet.this.pageLabel.setVisible(true);
                }
                PreviewApplet.this.progressBar.revalidate();
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewApplet.this.pageLabel.setText(PreviewApplet.this.previewPane.getPageNumber() + "/" + PreviewApplet.this.previewPane.getNumberOfPages());
            }
        }
    }
}

