/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.RequestFocusHandler;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PreviewDialog
extends JDialog {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private ReportProgressDialog progressDialog;
    private JLabel pageLabel;
    private Messages messages;

    public PreviewDialog() {
        this.init();
    }

    public PreviewDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public PreviewDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public PreviewDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public PreviewDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    public PreviewDialog(MasterReport report) {
        this.init();
        this.setReportJob(report);
    }

    public PreviewDialog(MasterReport report, Frame owner) {
        super(owner);
        this.init();
        this.setReportJob(report);
    }

    public PreviewDialog(MasterReport report, Frame owner, boolean modal) {
        super(owner, modal);
        this.init();
        this.setReportJob(report);
    }

    public PreviewDialog(MasterReport report, Dialog owner) {
        super(owner);
        this.init();
        this.setReportJob(report);
    }

    public PreviewDialog(MasterReport report, Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
        this.setReportJob(report);
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new RequestFocusHandler());
        this.messages = new Messages(this.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        this.previewPane = new PreviewPane();
        this.previewPane.setDeferredRepagination(true);
        this.addComponentListener(new TriggerPaginationListener(this.previewPane));
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.pageLabel = new JLabel();
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean progressBarEnabled = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.ProgressBarEnabled"));
        boolean progressDialogEnabled = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.ProgressDialogEnabled"));
        if (progressBarEnabled) {
            this.progressBar = new ReportProgressBar();
            this.progressBar.setVisible(false);
            this.previewPane.addReportProgressListener(this.progressBar);
            this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        } else {
            this.progressBar = null;
        }
        if (progressDialogEnabled) {
            this.progressDialog = new ReportProgressDialog(this);
            MasterReport reportJob = this.previewPane.getReportJob();
            if (reportJob == null || reportJob.getTitle() == null) {
                this.progressDialog.setTitle(this.messages.getString("ProgressDialog.EMPTY_TITLE"));
                this.progressDialog.setMessage(this.messages.getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                this.progressDialog.setTitle(this.messages.getString("ProgressDialog.TITLE", reportJob.getTitle()));
                this.progressDialog.setMessage(this.messages.getString("ProgressDialog.TITLE", reportJob.getTitle()));
            }
            this.progressDialog.pack();
        } else {
            this.progressDialog = null;
        }
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        if (this.progressBar != null) {
            extensionArea.add(this.progressBar);
        }
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
        this.updateMenu(this.previewPane.getMenu());
        this.setTitle(this.previewPane.getTitle());
        this.statusBar.setIconTheme(this.previewPane.getIconTheme());
        this.statusBar.setStatus(this.previewPane.getStatusType(), this.previewPane.getStatusText());
    }

    private void updateMenu(JMenu[] menus) {
        if (menus != null && menus.length > 0) {
            JMenuBar menuBar = new JMenuBar();
            for (int i = 0; i < menus.length; ++i) {
                JMenu menu = menus[i];
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
        } else {
            this.setJMenuBar(null);
        }
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public MasterReport getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(MasterReport reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    public void dispose() {
        super.dispose();
        this.previewPane.setClosed(true);
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean isToolbarFloatable() {
        return this.previewPane.isToolbarFloatable();
    }

    public void setToolbarFloatable(boolean toolbarFloatable) {
        this.previewPane.setToolbarFloatable(toolbarFloatable);
    }

    public double getZoom() {
        return this.previewPane.getZoom();
    }

    public void setZoom(double zoom) {
        this.previewPane.setZoom(zoom);
    }

    private static class TriggerPaginationListener
    extends ComponentAdapter {
        private PreviewPane pane;

        private TriggerPaginationListener(PreviewPane pane) {
            this.pane = pane;
        }

        public void componentShown(ComponentEvent e) {
            if (this.pane.isDeferredRepagination()) {
                this.pane.startPagination();
            }
        }
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        protected PreviewPanePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            PreviewPane previewPane = PreviewDialog.this.getPreviewPane();
            JStatusBar statusBar = PreviewDialog.this.getStatusBar();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = previewPane.getMenu();
                PreviewDialog.this.updateMenu(menus);
                return;
            }
            if ("title".equals(propertyName)) {
                PreviewDialog.this.setTitle(previewPane.getTitle());
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                statusBar.setStatus(previewPane.getStatusType(), previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                statusBar.setIconTheme(previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewDialog.this.pageLabel.setVisible(false);
                    statusBar.setStatus(StatusType.INFORMATION, PreviewDialog.this.messages.getString("PreviewDialog.USER_PAGINATING"));
                    if (PreviewDialog.this.progressBar != null) {
                        previewPane.addReportProgressListener(PreviewDialog.this.progressBar);
                        PreviewDialog.this.progressBar.setOnlyPagination(true);
                        PreviewDialog.this.progressBar.setVisible(true);
                        PreviewDialog.this.progressBar.revalidate();
                    }
                    if (PreviewDialog.this.progressDialog != null) {
                        previewPane.addReportProgressListener(PreviewDialog.this.progressDialog);
                        SwingUtil.centerDialogInParent(PreviewDialog.this.progressDialog);
                        PreviewDialog.this.progressDialog.setOnlyPagination(true);
                        PreviewDialog.this.progressDialog.setVisible(true);
                    }
                } else {
                    PreviewDialog.this.pageLabel.setVisible(true);
                    statusBar.setStatus(StatusType.NONE, "");
                    if (PreviewDialog.this.progressBar != null) {
                        PreviewDialog.this.progressBar.setOnlyPagination(false);
                        PreviewDialog.this.progressBar.setVisible(false);
                        previewPane.removeReportProgressListener(PreviewDialog.this.progressBar);
                        PreviewDialog.this.progressBar.revalidate();
                    }
                    if (PreviewDialog.this.progressDialog != null) {
                        previewPane.removeReportProgressListener(PreviewDialog.this.progressDialog);
                        PreviewDialog.this.progressDialog.setOnlyPagination(false);
                        PreviewDialog.this.progressDialog.setVisible(false);
                    }
                }
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewDialog.this.pageLabel.setText(previewPane.getPageNumber() + "/" + previewPane.getNumberOfPages());
                return;
            }
            if ("closed".equals(propertyName)) {
                if (previewPane.isClosed()) {
                    PreviewDialog.this.setVisible(false);
                    PreviewDialog.this.dispose();
                } else {
                    PreviewDialog.this.setVisible(true);
                }
            }
        }
    }
}

