/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.RequestFocusHandler;

public class PreviewInternalFrame
extends JInternalFrame {
    private PreviewPane previewPane;
    private JStatusBar statusBar;
    private ReportProgressBar progressBar;
    private JLabel pageLabel;

    public PreviewInternalFrame() {
        this.init();
    }

    public PreviewInternalFrame(MasterReport report) {
        this.init();
        this.setReportJob(report);
    }

    protected void init() {
        this.addComponentListener(new RequestFocusHandler());
        this.previewPane = new PreviewPane();
        this.previewPane.setDeferredRepagination(true);
        this.addComponentListener(new TriggerPaginationListener(this.previewPane));
        this.statusBar = new JStatusBar(this.previewPane.getIconTheme());
        this.progressBar = new ReportProgressBar();
        this.progressBar.setVisible(false);
        this.previewPane.addReportProgressListener(this.progressBar);
        this.pageLabel = new JLabel();
        this.previewPane.addPropertyChangeListener(new PreviewPanePropertyChangeHandler());
        JComponent extensionArea = this.statusBar.getExtensionArea();
        extensionArea.setLayout(new BoxLayout(extensionArea, 0));
        extensionArea.add(this.progressBar);
        extensionArea.add(this.pageLabel);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.previewPane, "Center");
        contentPane.add((Component)this.statusBar, "South");
        this.setContentPane(contentPane);
        this.updateMenu(this.previewPane.getMenu());
        this.setTitle(this.previewPane.getTitle());
        this.statusBar.setIconTheme(this.previewPane.getIconTheme());
        this.statusBar.setStatus(this.previewPane.getStatusType(), this.previewPane.getStatusText());
    }

    private void updateMenu(JMenu[] menus) {
        if (menus != null && menus.length > 0) {
            JMenuBar menuBar = new JMenuBar();
            for (int i = 0; i < menus.length; ++i) {
                JMenu menu = menus[i];
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
        } else {
            this.setJMenuBar(null);
        }
    }

    public ReportController getReportController() {
        return this.previewPane.getReportController();
    }

    public void setReportController(ReportController reportController) {
        this.previewPane.setReportController(reportController);
    }

    public IconTheme getIconTheme() {
        return this.previewPane.getIconTheme();
    }

    public void setIconTheme(IconTheme theme) {
        this.previewPane.setIconTheme(theme);
    }

    public MasterReport getReportJob() {
        return this.previewPane.getReportJob();
    }

    public void setReportJob(MasterReport reportJob) {
        this.previewPane.setReportJob(reportJob);
    }

    public void dispose() {
        super.dispose();
        this.previewPane.setClosed(true);
    }

    public PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public boolean isToolbarFloatable() {
        return this.previewPane.isToolbarFloatable();
    }

    public void setToolbarFloatable(boolean toolbarFloatable) {
        this.previewPane.setToolbarFloatable(toolbarFloatable);
    }

    public double getZoom() {
        return this.previewPane.getZoom();
    }

    public void setZoom(double zoom) {
        this.previewPane.setZoom(zoom);
    }

    private static class TriggerPaginationListener
    extends ComponentAdapter {
        private PreviewPane pane;

        private TriggerPaginationListener(PreviewPane pane) {
            this.pane = pane;
        }

        public void componentShown(ComponentEvent e) {
            if (this.pane.isDeferredRepagination()) {
                this.pane.startPagination();
            }
        }
    }

    private class PreviewPanePropertyChangeHandler
    implements PropertyChangeListener {
        protected PreviewPanePropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("menu".equals(propertyName)) {
                JMenu[] menus = PreviewInternalFrame.this.previewPane.getMenu();
                if (menus != null && menus.length > 0) {
                    JMenuBar menuBar = new JMenuBar();
                    for (int i = 0; i < menus.length; ++i) {
                        JMenu menu = menus[i];
                        menuBar.add(menu);
                    }
                    PreviewInternalFrame.this.setJMenuBar(menuBar);
                } else {
                    PreviewInternalFrame.this.setJMenuBar(null);
                }
                return;
            }
            if ("title".equals(propertyName)) {
                PreviewInternalFrame.this.setTitle(PreviewInternalFrame.this.previewPane.getTitle());
                return;
            }
            if ("statusText".equals(propertyName) || "statusType".equals(propertyName)) {
                PreviewInternalFrame.this.statusBar.setStatus(PreviewInternalFrame.this.previewPane.getStatusType(), PreviewInternalFrame.this.previewPane.getStatusText());
                return;
            }
            if ("iconTheme".equals(propertyName)) {
                PreviewInternalFrame.this.statusBar.setIconTheme(PreviewInternalFrame.this.previewPane.getIconTheme());
                return;
            }
            if ("paginating".equals(propertyName)) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    PreviewInternalFrame.this.progressBar.setOnlyPagination(true);
                    PreviewInternalFrame.this.progressBar.setVisible(true);
                    PreviewInternalFrame.this.pageLabel.setVisible(false);
                } else {
                    PreviewInternalFrame.this.progressBar.setOnlyPagination(true);
                    PreviewInternalFrame.this.progressBar.setVisible(false);
                    PreviewInternalFrame.this.pageLabel.setVisible(true);
                }
                PreviewInternalFrame.this.progressBar.revalidate();
                return;
            }
            if ("pageNumber".equals(propertyName) || "numberOfPages".equals(propertyName)) {
                PreviewInternalFrame.this.pageLabel.setText(PreviewInternalFrame.this.previewPane.getPageNumber() + "/" + PreviewInternalFrame.this.previewPane.getNumberOfPages());
                return;
            }
            if ("closed".equals(propertyName)) {
                if (PreviewInternalFrame.this.previewPane.isClosed()) {
                    try {
                        PreviewInternalFrame.this.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    PreviewInternalFrame.this.dispose();
                } else {
                    PreviewInternalFrame.this.setVisible(true);
                }
            }
        }
    }
}

