/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.about;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class SystemPropertiesPanel
extends JPanel {
    private JTable table;
    private JPopupMenu copyPopupMenu;

    public SystemPropertiesPanel() {
        ResourceBundleSupport bundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        this.setLayout(new BorderLayout());
        this.table = SystemPropertiesPanel.createSystemPropertiesTable();
        this.add(new JScrollPane(this.table));
        this.copyPopupMenu = new JPopupMenu();
        String label = bundleSupport.getString("system-properties-panel.popup-menu.copy");
        KeyStroke accelerator = bundleSupport.getKeyStroke("system-properties-panel.popup-menu.copy.accelerator");
        JMenuItem copyMenuItem = new JMenuItem(label);
        copyMenuItem.setAccelerator(accelerator);
        copyMenuItem.getAccessibleContext().setAccessibleDescription(label);
        copyMenuItem.addActionListener(new CopyAction());
        this.copyPopupMenu.add(copyMenuItem);
        PopupListener copyPopupListener = new PopupListener();
        this.table.addMouseListener(copyPopupListener);
    }

    public static JTable createSystemPropertiesTable() {
        ResourceBundle resources = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages");
        Object[] names = new String[]{resources.getString("system-properties-table.column.name"), resources.getString("system-properties-table.column.value")};
        Properties sysProps = System.getProperties();
        TreeMap<Object, Object> data = new TreeMap<Object, Object>(sysProps);
        Map.Entry[] entries = data.entrySet().toArray(new Map.Entry[data.size()]);
        DefaultTableModel properties = new DefaultTableModel(names, entries.length);
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = entries[i];
            properties.setValueAt(entry.getKey(), i, 0);
            properties.setValueAt(entry.getValue(), i, 1);
        }
        JTable table = new JTable(properties);
        TableColumnModel model = table.getColumnModel();
        TableColumn column = model.getColumn(0);
        column.setPreferredWidth(200);
        column = model.getColumn(1);
        column.setPreferredWidth(350);
        table.setAutoResizeMode(2);
        return table;
    }

    public void copySystemPropertiesToClipboard() {
        StringBuilder buffer = new StringBuilder(500);
        ListSelectionModel selection = this.table.getSelectionModel();
        int firstRow = selection.getMinSelectionIndex();
        int lastRow = selection.getMaxSelectionIndex();
        if (firstRow != -1 && lastRow != -1) {
            for (int r = firstRow; r <= lastRow; ++r) {
                for (int c = 0; c < this.table.getColumnCount(); ++c) {
                    buffer.append(this.table.getValueAt(r, c));
                    if (c == 2) continue;
                    buffer.append('\t');
                }
                buffer.append('\n');
            }
        }
        StringSelection ss = new StringSelection(buffer.toString());
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(ss, ss);
    }

    protected final JPopupMenu getCopyPopupMenu() {
        return this.copyPopupMenu;
    }

    protected final JTable getTable() {
        return this.table;
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SystemPropertiesPanel.this.getCopyPopupMenu().show(SystemPropertiesPanel.this.getTable(), e.getX(), e.getY());
            }
        }
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SystemPropertiesPanel.this.copySystemPropertiesToClipboard();
        }
    }
}

