/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.PaginatedUpdateListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.NumericInputDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class ZoomCustomActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;
    private static final Log logger = LogFactory.getLog(ZoomCustomActionPlugin.class);
    private PaginatedUpdateListener updateListener = new PaginatedUpdateListener(this);

    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        swingGuiContext.getEventSource().removePropertyChangeListener(this.updateListener);
    }

    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        context.getEventSource().addPropertyChangeListener(this.updateListener);
        this.setEnabled(context.getEventSource().isPaginated());
        return true;
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.base.zoom-custom.";
    }

    public String getDisplayName() {
        return this.resources.getString("action.zoomCustom.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.zoomCustom.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.zoomCustom.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.zoomCustom.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.zoomCustom.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.zoomCustom.mnemonic");
    }

    public boolean configure(PreviewPane reportPane) {
        Integer result = NumericInputDialog.showInputDialog(this.getContext().getWindow(), 3, this.resources.getString("dialog.zoom.title"), this.resources.getString("dialog.zoom.message"), 25, 400, (int)(reportPane.getZoom() * 100.0), false);
        if (result == null) {
            return false;
        }
        try {
            double zoom = result.doubleValue();
            reportPane.setZoom(zoom / 100.0);
            return true;
        }
        catch (Exception ex) {
            logger.info((Object)this.resources.getString("ZoomCustomActionPlugin.INFO_EXCEPTION_SWALLOWED"));
            return false;
        }
    }
}

