/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.date.SerialDate;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class DateChooserPanel
extends JPanel {
    public static final String PROPERTY_DATE = "date";
    private Calendar dateView;
    private Date selectedDate;
    private Color chosenDateButtonColor;
    private Color chosenMonthButtonColor;
    private Color chosenOtherButtonColor;
    private int firstDayOfWeek;
    private int yearSelectionRange = 20;
    private Font dateFont = new Font("SansSerif", 0, 10);
    private JComboBox monthSelector;
    private JComboBox yearSelector;
    private JButton[] buttons;
    private boolean refreshing = false;
    private int[] WEEK_DAYS;

    public DateChooserPanel() {
        this(Calendar.getInstance(), false);
    }

    public DateChooserPanel(Calendar calendar, boolean controlPanel) {
        super(new BorderLayout());
        this.chosenDateButtonColor = UIManager.getColor("textHighlight");
        this.chosenMonthButtonColor = UIManager.getColor("control");
        this.chosenOtherButtonColor = UIManager.getColor("controlShadow");
        this.dateView = calendar;
        this.firstDayOfWeek = calendar.getFirstDayOfWeek();
        this.WEEK_DAYS = new int[7];
        for (int i = 0; i < 7; ++i) {
            this.WEEK_DAYS[i] = (this.firstDayOfWeek + i - 1) % 7 + 1;
        }
        this.add((Component)this.constructSelectionPanel(), "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        if (controlPanel) {
            this.add((Component)this.constructControlPanel(), "South");
        }
        this.setDate(calendar.getTime());
    }

    public void setDate(Date theDate) {
        Date oldDate = this.selectedDate;
        this.selectedDate = theDate;
        if (theDate != null) {
            this.dateView.setTime(theDate);
            this.monthSelector.setSelectedIndex(this.dateView.get(2));
            this.refreshYearSelector();
            this.refreshButtons();
        }
        this.firePropertyChange(PROPERTY_DATE, oldDate, theDate);
    }

    public Date getDate() {
        return this.selectedDate;
    }

    private JPanel getCalendarPanel() {
        int i;
        JPanel p = new JPanel(new GridLayout(7, 7));
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        String[] weekDays = dateFormatSymbols.getShortWeekdays();
        for (i = 0; i < this.WEEK_DAYS.length; ++i) {
            p.add(new JLabel(weekDays[this.WEEK_DAYS[i]], 0));
        }
        this.buttons = new JButton[42];
        for (i = 0; i < 42; ++i) {
            JButton b = new JButton("");
            b.setMargin(new Insets(1, 1, 1, 1));
            b.setName(Integer.toString(i));
            b.setFont(this.dateFont);
            b.setFocusPainted(false);
            b.putClientProperty("JButton.buttonType", "square");
            this.buttons[i] = b;
            p.add(b);
        }
        return p;
    }

    private Color getButtonColor(Calendar theDate) {
        if (this.equalDates(theDate, this.dateView)) {
            return this.chosenDateButtonColor;
        }
        if (theDate.get(2) == this.dateView.get(2)) {
            return this.chosenMonthButtonColor;
        }
        return this.chosenOtherButtonColor;
    }

    private boolean equalDates(Calendar c1, Calendar c2) {
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    private Calendar getFirstVisibleDate() {
        Calendar c = Calendar.getInstance();
        c.set(this.dateView.get(1), this.dateView.get(2), 1);
        c.add(5, -1);
        while (c.get(7) != this.getFirstDayOfWeek()) {
            c.add(5, -1);
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.set(15, 3);
        return c;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    private void refreshButtons() {
        Calendar c = this.getFirstVisibleDate();
        for (int i = 0; i < 42; ++i) {
            JButton b = this.buttons[i];
            b.setAction(new SelectDayAction(c.getTime(), String.valueOf(c.get(5))));
            b.setBackground(this.getButtonColor(c));
            c.add(5, 1);
        }
    }

    private void refreshYearSelector() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.yearSelector.removeAllItems();
            Integer[] years = this.getYears(this.dateView.get(1));
            for (int i = 0; i < years.length; ++i) {
                this.yearSelector.addItem(years[i]);
            }
            this.yearSelector.setSelectedItem(new Integer(this.dateView.get(1)));
            this.refreshing = false;
        }
    }

    private Integer[] getYears(int chosenYear) {
        int size = this.yearSelectionRange * 2 + 1;
        int start = chosenYear - this.yearSelectionRange;
        Integer[] years = new Integer[size];
        for (int i = 0; i < size; ++i) {
            years[i] = new Integer(i + start);
        }
        return years;
    }

    private JPanel constructSelectionPanel() {
        JPanel p = new JPanel();
        int minMonth = this.dateView.getMinimum(2);
        int maxMonth = this.dateView.getMaximum(2);
        String[] months = new String[maxMonth - minMonth + 1];
        System.arraycopy(SerialDate.getMonths(), minMonth, months, 0, months.length);
        this.monthSelector = new JComboBox<String>(months);
        this.monthSelector.addActionListener(new MonthSelectionAction());
        p.add(this.monthSelector);
        this.yearSelector = new JComboBox<Integer>(this.getYears(0));
        this.yearSelector.addActionListener(new YearSelectionAction());
        p.add(this.yearSelector);
        return p;
    }

    private JPanel constructControlPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        p.add(new JButton(new SelectTodayAction()));
        return p;
    }

    public Color getChosenDateButtonColor() {
        return this.chosenDateButtonColor;
    }

    public void setChosenDateButtonColor(Color chosenDateButtonColor) {
        if (chosenDateButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenDateButtonColor;
        this.chosenDateButtonColor = chosenDateButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenDateButtonColor", oldValue, chosenDateButtonColor);
    }

    public Color getChosenMonthButtonColor() {
        return this.chosenMonthButtonColor;
    }

    public void setChosenMonthButtonColor(Color chosenMonthButtonColor) {
        if (chosenMonthButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenMonthButtonColor;
        this.chosenMonthButtonColor = chosenMonthButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenMonthButtonColor", oldValue, chosenMonthButtonColor);
    }

    public Color getChosenOtherButtonColor() {
        return this.chosenOtherButtonColor;
    }

    public void setChosenOtherButtonColor(Color chosenOtherButtonColor) {
        if (chosenOtherButtonColor == null) {
            throw new NullPointerException("UIColor must not be null.");
        }
        Color oldValue = this.chosenOtherButtonColor;
        this.chosenOtherButtonColor = chosenOtherButtonColor;
        this.refreshButtons();
        this.firePropertyChange("chosenOtherButtonColor", oldValue, chosenOtherButtonColor);
    }

    public int getYearSelectionRange() {
        return this.yearSelectionRange;
    }

    public void setYearSelectionRange(int yearSelectionRange) {
        int oldYearSelectionRange = this.yearSelectionRange;
        this.yearSelectionRange = yearSelectionRange;
        this.refreshYearSelector();
        this.firePropertyChange("yearSelectionRange", oldYearSelectionRange, yearSelectionRange);
    }

    private class SelectDayAction
    extends AbstractAction {
        private Date number;

        private SelectDayAction(Date selectedDate, String number) {
            this.number = selectedDate;
            this.putValue("Name", number);
        }

        public void actionPerformed(ActionEvent e) {
            DateChooserPanel.this.setDate(this.number);
        }
    }

    private class SelectTodayAction
    extends AbstractAction {
        private SelectTodayAction() {
            ResourceBundleSupport resourceBundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(DateChooserPanel.class));
            this.putValue("Name", resourceBundleSupport.getString("DateChooserPanel.Today"));
        }

        public void actionPerformed(ActionEvent e) {
            DateChooserPanel.this.setDate(new Date());
        }
    }

    private class YearSelectionAction
    implements ActionListener {
        private YearSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!DateChooserPanel.this.refreshing) {
                JComboBox c = (JComboBox)e.getSource();
                Integer y = (Integer)c.getSelectedItem();
                int dayOfMonth = DateChooserPanel.this.dateView.get(5);
                DateChooserPanel.this.dateView.set(5, 1);
                DateChooserPanel.this.dateView.set(1, y);
                int maxDayOfMonth = DateChooserPanel.this.dateView.getActualMaximum(5);
                DateChooserPanel.this.dateView.set(5, Math.min(dayOfMonth, maxDayOfMonth));
                DateChooserPanel.this.selectedDate = DateChooserPanel.this.dateView.getTime();
                DateChooserPanel.this.refreshYearSelector();
                DateChooserPanel.this.refreshButtons();
            }
        }
    }

    private class MonthSelectionAction
    implements ActionListener {
        private MonthSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox c = (JComboBox)e.getSource();
            int dayOfMonth = DateChooserPanel.this.dateView.get(5);
            DateChooserPanel.this.dateView.set(5, 1);
            DateChooserPanel.this.dateView.set(2, c.getSelectedIndex());
            int maxDayOfMonth = DateChooserPanel.this.dateView.getActualMaximum(5);
            DateChooserPanel.this.dateView.set(5, Math.min(dayOfMonth, maxDayOfMonth));
            DateChooserPanel.this.selectedDate = DateChooserPanel.this.dateView.getTime();
            DateChooserPanel.this.refreshButtons();
        }
    }
}

